// Code generated by 'simdgen -o godefs -goroot $GOROOT -xedPath $XED_PATH go.yaml types.yaml categories.yaml'; DO NOT EDIT.

//go:build goexperiment.simd

package archsimd

import "internal/cpu"

type X86Features struct{}

var X86 X86Features

// AVX returns whether the CPU supports the AVX feature.
//
// AVX is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX() bool {
	return cpu.X86.HasAVX
}

// AVX2 returns whether the CPU supports the AVX2 feature.
//
// If it returns true, then the CPU also supports AVX.
//
// AVX2 is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX2() bool {
	return cpu.X86.HasAVX2
}

// AVX512 returns whether the CPU supports the AVX512F+CD+BW+DQ+VL features.
//
// These five CPU features are bundled together, and no use of AVX-512
// is allowed unless all of these features are supported together.
// Nearly every CPU that has shipped with any support for AVX-512 has
// supported all five of these features.
//
// If it returns true, then the CPU also supports AVX and AVX2.
//
// AVX512 is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512() bool {
	return cpu.X86.HasAVX512
}

// AVX512BITALG returns whether the CPU supports the AVX512BITALG feature.
//
// If it returns true, then the CPU also supports AVX, AVX2, and AVX512.
//
// AVX512BITALG is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512BITALG() bool {
	return cpu.X86.HasAVX512BITALG
}

// AVX512GFNI returns whether the CPU supports the AVX512GFNI feature.
//
// If it returns true, then the CPU also supports AVX, AVX2, and AVX512.
//
// AVX512GFNI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512GFNI() bool {
	return cpu.X86.HasAVX512GFNI
}

// AVX512VAES returns whether the CPU supports the AVX512VAES feature.
//
// If it returns true, then the CPU also supports AVX, AVX2, and AVX512.
//
// AVX512VAES is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VAES() bool {
	return cpu.X86.HasAVX512VAES
}

// AVX512VBMI returns whether the CPU supports the AVX512VBMI feature.
//
// If it returns true, then the CPU also supports AVX, AVX2, and AVX512.
//
// AVX512VBMI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VBMI() bool {
	return cpu.X86.HasAVX512VBMI
}

// AVX512VBMI2 returns whether the CPU supports the AVX512VBMI2 feature.
//
// If it returns true, then the CPU also supports AVX, AVX2, and AVX512.
//
// AVX512VBMI2 is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VBMI2() bool {
	return cpu.X86.HasAVX512VBMI2
}

// AVX512VNNI returns whether the CPU supports the AVX512VNNI feature.
//
// If it returns true, then the CPU also supports AVX, AVX2, and AVX512.
//
// AVX512VNNI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VNNI() bool {
	return cpu.X86.HasAVX512VNNI
}

// AVX512VPCLMULQDQ returns whether the CPU supports the AVX512VPCLMULQDQ feature.
//
// AVX512VPCLMULQDQ is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VPCLMULQDQ() bool {
	return cpu.X86.HasAVX512VPCLMULQDQ
}

// AVX512VPOPCNTDQ returns whether the CPU supports the AVX512VPOPCNTDQ feature.
//
// If it returns true, then the CPU also supports AVX, AVX2, and AVX512.
//
// AVX512VPOPCNTDQ is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VPOPCNTDQ() bool {
	return cpu.X86.HasAVX512VPOPCNTDQ
}

// AVXAES returns whether the CPU supports the AVXAES feature.
//
// If it returns true, then the CPU also supports AES and AVX.
//
// AVXAES is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVXAES() bool {
	return cpu.X86.HasAVX && cpu.X86.HasAES
}

// AVXVNNI returns whether the CPU supports the AVXVNNI feature.
//
// If it returns true, then the CPU also supports AVX and AVX2.
//
// AVXVNNI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVXVNNI() bool {
	return cpu.X86.HasAVXVNNI
}

// FMA returns whether the CPU supports the FMA feature.
//
// If it returns true, then the CPU also supports AVX.
//
// FMA is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) FMA() bool {
	return cpu.X86.HasFMA
}

// SHA returns whether the CPU supports the SHA feature.
//
// SHA is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) SHA() bool {
	return cpu.X86.HasSHA
}

// VAES returns whether the CPU supports the VAES feature.
//
// If it returns true, then the CPU also supports AVX.
//
// VAES is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) VAES() bool {
	return cpu.X86.HasVAES
}
