from __future__ import annotations
import collections.abc
import datetime
import typing
from warnings import deprecated # type: ignore

import jpype # type: ignore
import jpype.protocol # type: ignore

import ghidra.app.util.bin
import ghidra.app.util.bin.format.pe.cli.streams
import ghidra.app.util.bin.format.pe.cli.tables
import ghidra.program.model.data
import java.lang # type: ignore


class CliIndexHasConstant(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexCustomAttributeType(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexHasFieldMarshall(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexHasSemantics(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexHasDeclSecurity(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexMethodDefOrRef(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexImplementation(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliCodedIndexUtils(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int], bitsUsed: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int], bitsUsed: typing.Union[jpype.JInt, int], tables: jpype.JArray[ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata, bitsUsed: typing.Union[jpype.JInt, int], tables: jpype.JArray[ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable]) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata, bitsUsed: typing.Union[jpype.JInt, int], tables: jpype.JArray[ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable]) -> ghidra.program.model.data.DataType:
        ...


class CliIndexMemberRefParent(CliCodedIndexUtils):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexTypeDefOrRef(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexMemberForwarded(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexTypeOrMethodDef(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexResolutionScope(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...


class CliIndexHasCustomAttribute(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self):
        ...

    @staticmethod
    def getRowIndex(codedIndex: typing.Union[jpype.JInt, int]) -> int:
        ...

    @staticmethod
    def getTableName(codedIndex: typing.Union[jpype.JInt, int]) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable:
        ...

    @staticmethod
    def readCodedIndex(reader: ghidra.app.util.bin.BinaryReader, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> int:
        ...

    @staticmethod
    def toDataType(stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.program.model.data.DataType:
        ...



__all__ = ["CliIndexHasConstant", "CliIndexCustomAttributeType", "CliIndexHasFieldMarshall", "CliIndexHasSemantics", "CliIndexHasDeclSecurity", "CliIndexMethodDefOrRef", "CliIndexImplementation", "CliCodedIndexUtils", "CliIndexMemberRefParent", "CliIndexTypeDefOrRef", "CliIndexMemberForwarded", "CliIndexTypeOrMethodDef", "CliIndexResolutionScope", "CliIndexHasCustomAttribute"]
