/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.db;

import db.DBFileListener;
import db.DBHandle;
import db.Database;
import db.buffers.BufferFile;
import db.buffers.BufferFileManager;
import db.buffers.BufferMgr;
import db.buffers.LocalBufferFile;
import db.buffers.LocalManagedBufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class PrivateDatabase
extends Database {
    private PrivateDatabase(File dbDir, DBFileListener dbFileListener) throws IOException {
        super(dbDir, dbFileListener, true);
    }

    public PrivateDatabase(File dbDir) throws IOException {
        super(dbDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateDatabase(File dbDir, BufferFile srcFile, boolean resetDatabaseId, TaskMonitor monitor) throws IOException, CancelledException {
        super(dbDir, null, true);
        boolean success = false;
        LocalManagedBufferFile newFile = null;
        try {
            newFile = new LocalManagedBufferFile(srcFile.getBufferSize(), this.bfMgr, -1L);
            LocalBufferFile.copyFile((BufferFile)srcFile, (BufferFile)newFile, null, (TaskMonitor)monitor);
            newFile.close();
            if (resetDatabaseId) {
                DBHandle.resetDatabaseId((File)this.bfMgr.getBufferFile(1));
            }
            success = true;
        }
        finally {
            if (!success) {
                if (newFile != null) {
                    newFile.delete();
                }
                if (this.dbDirCreated) {
                    PrivateDatabase.deleteDir((File)dbDir);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateDatabase(File dbDir, File packedFile, TaskMonitor monitor) throws IOException, CancelledException {
        super(dbDir, null, true);
        boolean success = false;
        try {
            PackedDatabase.unpackDatabase(this.bfMgr, -1L, packedFile, monitor);
            DBHandle.resetDatabaseId((File)this.bfMgr.getBufferFile(1));
            success = true;
        }
        finally {
            if (!success && this.dbDirCreated) {
                PrivateDatabase.deleteDir((File)dbDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalManagedBufferFile createDatabase(File dbDir, DBFileListener dbFileListener, int bufferSize) throws IOException {
        PrivateDatabase db = new PrivateDatabase(dbDir, dbFileListener);
        boolean success = false;
        try {
            LocalManagedBufferFile bfile = new LocalManagedBufferFile(bufferSize, db.bfMgr, -1L);
            success = true;
            LocalManagedBufferFile localManagedBufferFile = bfile;
            return localManagedBufferFile;
        }
        finally {
            if (!success && db.dbDirCreated) {
                PrivateDatabase.deleteDir((File)dbDir);
            }
        }
    }

    public void setIsCheckoutCopy(boolean state) {
        this.isCheckOutCopy = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile openBufferFile() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            return new LocalManagedBufferFile(this.bfMgr, false, -1, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile openBufferFileForUpdate() throws IOException {
        if (!this.updateAllowed) {
            throw new IOException("Update use not permitted");
        }
        Object object = this.syncObject;
        synchronized (object) {
            return new LocalManagedBufferFile(this.bfMgr, true, -1, -1L);
        }
    }

    public boolean canRecover() {
        return BufferMgr.canRecover((BufferFileManager)this.bfMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dbMoved(File dir) throws FileNotFoundException {
        Object object = this.syncObject;
        synchronized (object) {
            this.dbDir = dir;
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCheckoutCopy(ManagedBufferFile srcFile, int oldVersion, TaskMonitor monitor) throws CancelledException, IOException {
        if (!this.isCheckOutCopy) {
            throw new IOException("Database is not a checkout copy");
        }
        Object object = this.syncObject;
        synchronized (object) {
            if (srcFile != null) {
                boolean success = false;
                LocalManagedBufferFile localBf = new LocalManagedBufferFile(this.bfMgr, true, -1, -1L);
                try {
                    localBf.updateFrom(srcFile, oldVersion, monitor);
                    localBf.close();
                    success = true;
                }
                finally {
                    if (!success) {
                        localBf.delete();
                    }
                }
            }
            new File(this.dbDir, "change.data.gbf").delete();
            new File(this.dbDir, "change.map.gbf").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCheckoutCopy() throws IOException {
        if (!this.isCheckOutCopy) {
            throw new IOException("Database is not a checkout copy");
        }
        Object object = this.syncObject;
        synchronized (object) {
            new File(this.dbDir, "change.data.gbf").delete();
            new File(this.dbDir, "change.map.gbf").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCheckoutFrom(PrivateDatabase otherDb) throws IOException {
        if (!this.isCheckOutCopy) {
            throw new IOException("Database is not a checkout copy");
        }
        Object object = this.syncObject;
        synchronized (object) {
            int newVersion = this.currentVersion + 1;
            File otherBufFile = otherDb.bfMgr.getBufferFile(otherDb.currentVersion);
            File otherChangeFile = new File(otherDb.dbDir, "change.data.gbf");
            File otherMapFile = new File(otherDb.dbDir, "change.map.gbf");
            File newBufFile = this.bfMgr.getBufferFile(newVersion);
            File changeFile = new File(this.dbDir, "change.data.gbf");
            File mapFile = new File(this.dbDir, "change.map.gbf");
            File backupChangeFile = new File(this.dbDir, "change.data.gbf.bak");
            File backupMapFile = new File(this.dbDir, "change.map.gbf.bak");
            backupMapFile.delete();
            backupChangeFile.delete();
            if (!otherBufFile.exists()) {
                throw new IOException("Update file not found");
            }
            if (newBufFile.exists() || !otherBufFile.renameTo(newBufFile)) {
                throw new IOException("Concurrent database modification error (1)");
            }
            boolean success = false;
            try {
                if (mapFile.exists() && !mapFile.renameTo(backupMapFile)) {
                    throw new IOException("Concurrent database modification error (2)");
                }
                if (changeFile.exists() && !changeFile.renameTo(backupChangeFile)) {
                    throw new IOException("Concurrent database modification error (3)");
                }
                if (!otherMapFile.renameTo(mapFile) || !otherChangeFile.renameTo(changeFile)) {
                    throw new IOException("Concurrent database modification error (4)");
                }
                this.currentVersion = newVersion;
                this.lastModified = newBufFile.lastModified();
                success = true;
            }
            finally {
                if (!success) {
                    newBufFile.delete();
                    mapFile.delete();
                    backupMapFile.renameTo(mapFile);
                    changeFile.delete();
                    backupChangeFile.renameTo(changeFile);
                } else {
                    backupChangeFile.delete();
                    backupMapFile.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(File outputFile, String name, int filetype, String contentType, TaskMonitor monitor) throws IOException, CancelledException {
        Object object = this.syncObject;
        synchronized (object) {
            File file = this.bfMgr.getBufferFile(this.currentVersion);
            BufferedInputStream itemIn = new BufferedInputStream(new FileInputStream(file));
            try {
                ItemSerializer.outputItem(name, contentType, filetype, file.length(), itemIn, outputFile, monitor);
            }
            finally {
                try {
                    ((InputStream)itemIn).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

