/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state.analysis;

import ghidra.program.model.pcode.Varnode;
import ghidra.util.state.VarnodeOperation;

class ComputedTableOffset {
    private final int factor;
    private final Varnode indexValue;

    ComputedTableOffset(Varnode indexValue, int factor) {
        this.indexValue = indexValue;
        this.factor = factor;
    }

    Varnode getIndexValue() {
        return this.indexValue;
    }

    int getTableEntrySize() {
        return this.factor;
    }

    static ComputedTableOffset getComputedTableOffset(Varnode v) {
        VarnodeOperation op;
        long factor;
        Varnode indexValue = null;
        if (v instanceof VarnodeOperation) {
            VarnodeOperation computedTableOffsetOperation = (VarnodeOperation)v;
            int opcode = computedTableOffsetOperation.getPCodeOp().getOpcode();
            if (opcode != 32 && opcode != 29) {
                return null;
            }
            Varnode[] inputValues = computedTableOffsetOperation.getInputValues();
            if (inputValues[1].isConstant()) {
                factor = inputValues[1].getOffset();
                if (opcode == 29) {
                    factor = 1L << (int)factor;
                }
                indexValue = inputValues[0];
            } else if (opcode == 32 && inputValues[0].isConstant()) {
                factor = inputValues[0].getOffset();
                indexValue = inputValues[1];
            } else {
                factor = 1L;
                indexValue = v;
            }
            if (factor <= 0L || factor > 8L) {
                return null;
            }
        } else {
            factor = 1L;
            indexValue = v;
        }
        if (indexValue instanceof VarnodeOperation && (op = (VarnodeOperation)indexValue).getPCodeOp().getOutput().isUnique() && op.getPCodeOp().getOpcode() == 17) {
            indexValue = op.getInputValues()[0];
        }
        return new ComputedTableOffset(indexValue, (int)factor);
    }
}

