/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ScriptControls;
import ghidra.app.util.headless.HeadlessAnalyzer;
import ghidra.app.util.headless.HeadlessErrorLogger;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.program.model.listing.Program;
import ghidra.util.ErrorLogger;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import utility.application.ApplicationLayout;

public class GhidraScriptRunner
implements GhidraLaunchable {
    private String propertiesFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
        if (args.length != 1) {
            GhidraScriptRunner.usage();
            System.exit(0);
        }
        String logFile = null;
        GhidraScriptUtil.acquireBundleHostReference();
        try {
            this.initialize((ApplicationLayout)layout, logFile, true);
            this.runScript(args[0]);
        }
        finally {
            GhidraScriptUtil.releaseBundleHostReference();
        }
    }

    private void runScript(String string) throws Exception {
        GhidraScript ghidraScript = this.getGhidraScript(string);
        GhidraState scriptState = new GhidraState(null, null, null, null, null, null);
        this.runScript(scriptState, ghidraScript);
    }

    private boolean runScript(GhidraState scriptState, GhidraScript script) {
        ResourceFile srcFile = script.getSourceFile();
        String scriptName = srcFile != null ? srcFile.getAbsolutePath() : script.getClass().getName() + ".class";
        try {
            Msg.info((Object)this, (Object)("SCRIPT: " + scriptName));
            ScriptControls controls = new ScriptControls(System.out, System.err, TaskMonitor.DUMMY);
            script.execute(scriptState, controls);
        }
        catch (Exception exc) {
            Program prog = scriptState.getCurrentProgram();
            String path = prog != null ? prog.getExecutablePath() : "Current program is null.";
            String logErrorMsg = path + "\nREPORT SCRIPT ERROR: " + scriptName + " : " + exc.getMessage();
            Msg.error((Object)this, (Object)logErrorMsg, (Throwable)exc);
            return false;
        }
        return true;
    }

    private static void usage() {
        System.out.println("usage: GhidraScriptRunner <scriptName>.java");
    }

    private GhidraScript getGhidraScript(String scriptName) throws Exception {
        ResourceFile scriptSourceFile = this.findScriptSourceFile(scriptName);
        GhidraScriptProvider provider = GhidraScriptUtil.getProvider(scriptSourceFile);
        if (provider == null) {
            throw new IOException("Missing plugin needed to run scripts of this type. Please ensure you have installed the necessary plugin.");
        }
        PrintWriter errWriter = new PrintWriter(System.err);
        GhidraScript foundScript = provider.getScriptInstance(scriptSourceFile, errWriter);
        if (this.propertiesFilePath != null) {
            String baseScriptName = foundScript.getScriptName();
            int lastIndexOf = baseScriptName.lastIndexOf(".");
            if (lastIndexOf > 0) {
                baseScriptName = baseScriptName.substring(0, lastIndexOf);
            }
            foundScript.setPropertiesFileLocation(this.propertiesFilePath, baseScriptName);
        }
        return foundScript;
    }

    private ResourceFile findScriptSourceFile(String scriptName) {
        if (scriptName.endsWith(".class")) {
            scriptName = scriptName.replace(".class", ".java");
        }
        ResourceFile scriptSource = new ResourceFile(scriptName);
        if ((scriptSource = scriptSource.getCanonicalFile()).exists()) {
            return scriptSource;
        }
        scriptSource = GhidraScriptUtil.findScriptByName(scriptName);
        if (scriptSource != null) {
            return scriptSource;
        }
        throw new IllegalArgumentException("Script not found: " + scriptName);
    }

    private synchronized void initialize(ApplicationLayout applicationLayout, String logFile, boolean useLog4j) {
        System.setProperty("SystemUtilities.isHeadless", Boolean.TRUE.toString());
        System.setProperty("java.awt.headless", "true");
        this.initializeApplication(applicationLayout, logFile, useLog4j);
        this.initializeScriptPaths();
    }

    protected synchronized void initializeApplication(ApplicationLayout applicationLayout, String logFile, boolean useLog4j) {
        HeadlessGhidraApplicationConfiguration configuration = new HeadlessGhidraApplicationConfiguration();
        if (useLog4j) {
            if (logFile != null) {
                configuration.setApplicationLogFile(new File(logFile));
            }
        } else {
            HeadlessErrorLogger fileErrorLogger = new HeadlessErrorLogger(new File(logFile));
            configuration.setInitializeLogging(false);
            Msg.setErrorLogger((ErrorLogger)fileErrorLogger);
        }
        Application.initializeApplication((ApplicationLayout)applicationLayout, (ApplicationConfiguration)configuration);
    }

    private void initializeScriptPaths() {
        StringBuffer buf = new StringBuffer("HEADLESS Script Paths:");
        for (ResourceFile dir : GhidraScriptUtil.getScriptSourceDirectories()) {
            buf.append("\n    ");
            buf.append(dir.getAbsolutePath());
        }
        Msg.info(HeadlessAnalyzer.class, (Object)buf.toString());
    }
}

