/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.OMFSrcModuleLine;
import java.io.IOException;
import java.util.ArrayList;

public class OMFSrcModuleFile {
    private short cSeg;
    private short pad;
    private int[] baseSrcLn;
    private int[] starts;
    private int[] ends;
    private byte cbName;
    private String name;
    private ArrayList<OMFSrcModuleLine> moduleLineList = new ArrayList();

    OMFSrcModuleFile(BinaryReader reader, int moduleBase, int ptr) throws IOException {
        int i;
        int index = ptr;
        this.cSeg = reader.readShort(index);
        this.pad = reader.readShort(index += 2);
        index += 2;
        this.baseSrcLn = new int[Short.toUnsignedInt(this.cSeg)];
        for (i = 0; i < this.cSeg; ++i) {
            this.baseSrcLn[i] = reader.readInt(index);
            index += 4;
        }
        this.starts = new int[Short.toUnsignedInt(this.cSeg)];
        this.ends = new int[Short.toUnsignedInt(this.cSeg)];
        for (i = 0; i < Short.toUnsignedInt(this.cSeg); ++i) {
            this.starts[i] = reader.readInt(index);
            this.ends[i] = reader.readInt(index += 4);
            index += 4;
        }
        this.cbName = reader.readByte(index);
        this.name = reader.readAsciiString(++index, Byte.toUnsignedInt(this.cbName));
        index += Byte.toUnsignedInt(this.cbName);
        for (i = 0; i < Short.toUnsignedInt(this.cSeg); ++i) {
            OMFSrcModuleLine line = new OMFSrcModuleLine(reader, moduleBase + this.baseSrcLn[i]);
            this.moduleLineList.add(line);
            index += line.getByteCount();
        }
    }

    public OMFSrcModuleLine[] getOMFSrcModuleLines() {
        OMFSrcModuleLine[] arr = new OMFSrcModuleLine[this.moduleLineList.size()];
        this.moduleLineList.toArray(arr);
        return arr;
    }

    public int[] getBaseSrcLn() {
        return this.baseSrcLn;
    }

    public short getSegmentCount() {
        return this.cSeg;
    }

    public int[] getEnds() {
        return this.ends;
    }

    public String getName() {
        return this.name;
    }

    public short getPad() {
        return this.pad;
    }

    public int[] getStarts() {
        return this.starts;
    }
}

