/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.mz;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.mz.OldDOSHeader;
import ghidra.app.util.bin.format.ne.InvalidWindowsHeaderException;
import ghidra.app.util.bin.format.ne.WindowsHeader;
import ghidra.app.util.bin.format.pe.InvalidNTHeaderException;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DOSHeader
extends OldDOSHeader {
    public static final String NAME = "IMAGE_DOS_HEADER";
    public static final int SIZEOF_DOS_HEADER = 64;
    private short[] e_res = new short[4];
    private short e_oemid;
    private short e_oeminfo;
    private short[] e_res2 = new short[10];
    private int e_lfanew;
    private byte[] stubBytes;

    public DOSHeader(BinaryReader reader) throws IOException {
        super(reader);
    }

    public short[] e_res() {
        return this.e_res;
    }

    public short e_oemid() {
        return this.e_oemid;
    }

    public short e_oeminfo() {
        return this.e_oeminfo;
    }

    public short[] e_res2() {
        return this.e_res2;
    }

    public int e_lfanew() {
        return this.e_lfanew;
    }

    @Override
    public boolean hasNewExeHeader() {
        if (this.e_lfanew >= 0 && this.e_lfanew <= 65536 && this.e_lfarlc() == 64) {
            try {
                new WindowsHeader(this.reader, null, (short)this.e_lfanew);
                return true;
            }
            catch (InvalidWindowsHeaderException | IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean hasPeHeader() {
        if (this.e_lfanew >= 0 && this.e_lfanew <= 0x1000000) {
            try {
                NTHeader ntHeader = new NTHeader(this.reader, this.e_lfanew, PortableExecutable.SectionLayout.FILE, false);
                if (ntHeader.getOptionalHeader() != null) {
                    return true;
                }
            }
            catch (InvalidNTHeaderException | IOException exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = (StructureDataType)super.toDataType();
        struct.add((DataType)new ArrayDataType(WORD, 4, 2));
        struct.add(WORD);
        struct.add(WORD);
        struct.add((DataType)new ArrayDataType(WORD, 10, 2));
        struct.add(DWORD);
        if (this.getProgramLen() > 0) {
            struct.add((DataType)new ArrayDataType(BYTE, this.getProgramLen(), 1));
        }
        struct.getComponent(14).setFieldName("e_res[4]");
        struct.getComponent(15).setFieldName("e_oemid");
        struct.getComponent(16).setFieldName("e_oeminfo");
        struct.getComponent(17).setFieldName("e_res2[10]");
        struct.getComponent(18).setFieldName("e_lfanew");
        if (this.getProgramLen() > 0) {
            struct.getComponent(19).setFieldName("e_program");
        }
        struct.getComponent(14).setComment("Reserved words");
        struct.getComponent(15).setComment("OEM identifier (for e_oeminfo)");
        struct.getComponent(16).setComment("OEM information; e_oemid specific");
        struct.getComponent(17).setComment("Reserved words");
        struct.getComponent(18).setComment("File address of new exe header");
        if (this.getProgramLen() > 0) {
            struct.getComponent(19).setComment("Actual DOS program");
        }
        return struct;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getProgramLen() {
        return this.stubBytes == null ? 0 : this.stubBytes.length;
    }

    @Override
    protected void parse() throws IOException {
        super.parse();
        if (!this.isDosSignature()) {
            return;
        }
        this.e_res = this.reader.readNextShortArray(4);
        this.e_oemid = this.reader.readNextShort();
        this.e_oeminfo = this.reader.readNextShort();
        this.e_res2 = this.reader.readNextShortArray(10);
        this.e_lfanew = this.reader.readNextInt();
        if (this.e_lfanew < 65536) {
            try {
                this.stubBytes = this.e_lfanew > 64 ? this.reader.readByteArray(64L, this.e_lfanew - 64) : new byte[]{};
            }
            catch (Exception exc) {
                this.stubBytes = new byte[0];
            }
        } else {
            this.stubBytes = new byte[0];
        }
    }

    public void decrementStub(int start) {
        if (this.stubBytes.length > 0) {
            try {
                this.stubBytes = start > 64 ? this.reader.readByteArray(64L, start - 64) : new byte[]{};
            }
            catch (Exception exc) {
                this.stubBytes = new byte[0];
            }
        }
    }

    @Override
    public void write(RandomAccessFile raf, DataConverter dc) throws IOException {
        super.write(raf, dc);
        for (short e_re : this.e_res) {
            raf.write(dc.getBytes(e_re));
        }
        raf.write(dc.getBytes(this.e_oemid));
        raf.write(dc.getBytes(this.e_oeminfo));
        for (short element : this.e_res2) {
            raf.write(dc.getBytes(element));
        }
        raf.write(dc.getBytes(this.e_lfanew));
        raf.write(this.stubBytes);
    }
}

