/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadState;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadStateARM
extends ThreadState {
    public static final int ARM_THREAD_STATE = 1;
    public static final int ARM_VFP_STATE = 2;
    public static final int ARM_EXCEPTION_STATE = 3;
    public static final int ARM_DEBUG_STATE = 4;
    public static final int THREAD_STATE_NONE = 5;
    public int r0;
    public int r1;
    public int r2;
    public int r3;
    public int r4;
    public int r5;
    public int r6;
    public int r7;
    public int r8;
    public int r9;
    public int r10;
    public int r11;
    public int r12;
    public int sp;
    public int lr;
    public int pc;
    public int cpsr;

    ThreadStateARM(BinaryReader reader) throws IOException {
        this.r0 = reader.readNextInt();
        this.r1 = reader.readNextInt();
        this.r2 = reader.readNextInt();
        this.r3 = reader.readNextInt();
        this.r4 = reader.readNextInt();
        this.r5 = reader.readNextInt();
        this.r6 = reader.readNextInt();
        this.r7 = reader.readNextInt();
        this.r8 = reader.readNextInt();
        this.r9 = reader.readNextInt();
        this.r10 = reader.readNextInt();
        this.r11 = reader.readNextInt();
        this.r12 = reader.readNextInt();
        this.sp = reader.readNextInt();
        this.lr = reader.readNextInt();
        this.pc = reader.readNextInt();
        this.cpsr = reader.readNextInt();
    }

    @Override
    public long getInstructionPointer() {
        return Integer.toUnsignedLong(this.pc);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("ARM_THREAD_STATE", 0);
        struct.add(DWORD, "r0", null);
        struct.add(DWORD, "r1", null);
        struct.add(DWORD, "r2", null);
        struct.add(DWORD, "r3", null);
        struct.add(DWORD, "r4", null);
        struct.add(DWORD, "r5", null);
        struct.add(DWORD, "r6", null);
        struct.add(DWORD, "r7", null);
        struct.add(DWORD, "r8", null);
        struct.add(DWORD, "r9", null);
        struct.add(DWORD, "r10", null);
        struct.add(DWORD, "r11", null);
        struct.add(DWORD, "r12", null);
        struct.add(DWORD, "sp", null);
        struct.add(DWORD, "lr", null);
        struct.add(DWORD, "pc", null);
        struct.add(DWORD, "cpsr", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

