/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FactoryStructureDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.DuplicateNameException;

class ElfRelrRelocationTableDataType
extends FactoryStructureDataType {
    private int length;
    private int entrySize;

    ElfRelrRelocationTableDataType(String structName, int length, int entrySize) {
        this(structName, length, entrySize, null);
    }

    private ElfRelrRelocationTableDataType(String structName, int length, int entrySize, DataTypeManager dtm) {
        super(structName, dtm);
        this.length = length;
        this.entrySize = entrySize;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.dataMgr) {
            return this;
        }
        return new ElfRelrRelocationTableDataType(this.getName(), this.length, this.entrySize, dtm);
    }

    private long readNextRelrEntry(MemBuffer buf, int bufOffset) throws MemoryAccessException {
        return this.entrySize == 8 ? buf.getLong(bufOffset) : buf.getUnsignedInt(bufOffset);
    }

    protected void populateDynamicStructure(MemBuffer buf, Structure struct) {
        QWordDataType entryDataType = this.entrySize == 8 ? QWordDataType.dataType : DWordDataType.dataType;
        int bufOffset = 0;
        int remaining = this.length;
        int index = 0;
        struct.add((DataType)entryDataType, "r_relr_base_" + ++index, null);
        bufOffset += this.entrySize;
        remaining -= this.entrySize;
        int bitMaskCount = 0;
        try {
            while (remaining > 0) {
                long nextValue = this.readNextRelrEntry(buf, bufOffset);
                if ((nextValue & 1L) == 1L) {
                    ++bitMaskCount;
                } else {
                    if (bitMaskCount != 0) {
                        ArrayDataType maskArray = new ArrayDataType((DataType)entryDataType, bitMaskCount, this.entrySize);
                        struct.add((DataType)maskArray, "r_relr_bits_" + index, null);
                        bitMaskCount = 0;
                    }
                    struct.add((DataType)entryDataType, "r_relr_base_" + ++index, null);
                }
                bufOffset += this.entrySize;
                remaining -= this.entrySize;
            }
            if (bitMaskCount != 0) {
                ArrayDataType maskArray = new ArrayDataType((DataType)entryDataType, bitMaskCount, this.entrySize);
                struct.add((DataType)maskArray, "r_relr_bits_" + index, null);
            }
        }
        catch (MemoryAccessException | IllegalArgumentException throwable) {
            // empty catch block
        }
    }

    protected Structure setCategoryPath(Structure struct, MemBuffer buf) {
        try {
            struct.setCategoryPath(new CategoryPath("/ELF"));
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        return struct;
    }
}

