/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.ElfHeader;
import java.io.IOException;

public class ElfCompressedSectionHeader {
    public static final int ELFCOMPRESS_ZLIB = 1;
    private static final int SIZEOF_HEADER_32 = 12;
    private static final int SIZEOF_HEADER_64 = 24;
    private int ch_type;
    private long ch_size;
    private long ch_addralign;
    private int headerSize;

    public static ElfCompressedSectionHeader read(BinaryReader reader, ElfHeader elf) throws IOException {
        return elf.is32Bit() ? ElfCompressedSectionHeader.read32(reader) : ElfCompressedSectionHeader.read64(reader);
    }

    private ElfCompressedSectionHeader(int type, long size, long align, int headerSize) {
        this.ch_type = type;
        this.ch_size = size;
        this.ch_addralign = align;
        this.headerSize = headerSize;
    }

    public int getCh_type() {
        return this.ch_type;
    }

    public long getCh_size() {
        return this.ch_size;
    }

    public long getCh_addralign() {
        return this.ch_addralign;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    private static ElfCompressedSectionHeader read32(BinaryReader reader) throws IOException {
        int type = reader.readNextInt();
        long size = reader.readNextUnsignedInt();
        long align = reader.readNextUnsignedInt();
        return new ElfCompressedSectionHeader(type, size, align, 12);
    }

    private static ElfCompressedSectionHeader read64(BinaryReader reader) throws IOException {
        int type = reader.readNextInt();
        reader.readNextUnsignedInt();
        long size = reader.readNextLong();
        long align = reader.readNextLong();
        return new ElfCompressedSectionHeader(type, size, align, 24);
    }
}

