/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.FileByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;

public class ObfuscatedFileByteProvider
extends FileByteProvider {
    static final byte[] XOR_MASK_BYTES = new byte[]{89, -22, 103, 35, -38, -72, 0, -72, -61, 72, -35, -117, 33, -42, -108, 120, 53, -85, 43, 126, -78, 79, -126, 78, 14, 22, -60, 87, 18, -114, 126, -26, -74, -67, 86, -111, 87, 114, -26, -111, -36, 82, 46, -14, 26, -73, -42, 111, -38, -34, -24, 72, -79, -69, 80, 111, -12, -35, 17, -18, -14, 103, -2, 72, -115, -82, 105, 26, -32, 38, -116, 36, -114, 23, 118, 81, -30, 96, -41, -26, -125, 101, -43, -16, 127, -14, -96, -42, 75, -67, 36, -40, -85, -22, -98, -90, 72, -108, 62, 123, 44, -12, -50, -36, 105, 17, -8, 60, -89, 63, 93, 119, -108, 63, -28, -114, 72, 32, -37, 86, 50, -63, -121, 1, 46, -29, 127, 64};

    public ObfuscatedFileByteProvider(File file, FSRL fsrl, AccessMode accessMode) throws IOException {
        super(file, fsrl, accessMode);
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    protected int doReadBytes(long index, byte[] buffer) throws IOException {
        int bytesRead = super.doReadBytes(index, buffer);
        int i = 0;
        while (i < bytesRead) {
            long byteIndex = index + (long)i;
            int xorMaskIndex = (int)(byteIndex % (long)XOR_MASK_BYTES.length);
            byte xorMask = XOR_MASK_BYTES[xorMaskIndex];
            int n = i++;
            buffer[n] = (byte)(buffer[n] ^ xorMask);
        }
        return bytesRead;
    }

    @Override
    protected void doWriteBytes(long index, byte[] buffer, int offset, int length) throws IOException {
        byte[] tmpBuffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            long byteIndex = index + (long)i;
            int xorMaskIndex = (int)(byteIndex % (long)XOR_MASK_BYTES.length);
            byte xorMask = XOR_MASK_BYTES[xorMaskIndex];
            tmpBuffer[i] = (byte)(buffer[i + offset] ^ xorMask);
        }
        super.doWriteBytes(index, tmpBuffer, 0, length);
    }
}

