/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GhidraScriptInfoManager {
    private Map<ResourceFile, ScriptInfo> scriptFileToInfoMap = new HashMap<ResourceFile, ScriptInfo>();
    private Map<String, List<ResourceFile>> scriptNameToFilesMap = new HashMap<String, List<ResourceFile>>();

    public void dispose() {
        this.clearMetadata();
    }

    public void clearMetadata() {
        this.scriptFileToInfoMap.clear();
        this.scriptNameToFilesMap.clear();
    }

    public void removeMetadata(ResourceFile scriptFile) {
        this.scriptFileToInfoMap.remove(scriptFile);
        String name = scriptFile.getName();
        List<ResourceFile> files = this.scriptNameToFilesMap.get(name);
        if (files != null) {
            files.remove(scriptFile);
            if (files.isEmpty()) {
                this.scriptNameToFilesMap.remove(name);
            }
        }
    }

    public Iterable<ScriptInfo> getScriptInfoIterable() {
        return () -> this.scriptFileToInfoMap.values().iterator();
    }

    public ScriptInfo getScriptInfo(ResourceFile scriptFile) {
        ScriptInfo info = this.scriptFileToInfoMap.get(scriptFile);
        if (info != null) {
            return info;
        }
        info = GhidraScriptUtil.newScriptInfo(scriptFile);
        this.scriptFileToInfoMap.put(scriptFile, info);
        String name = scriptFile.getName();
        List matchingFiles = this.scriptNameToFilesMap.computeIfAbsent(name, n -> new ArrayList());
        matchingFiles.add(scriptFile);
        this.markAnyDuplicates(matchingFiles);
        return info;
    }

    public boolean containsMetadata(ResourceFile scriptFile) {
        return this.scriptFileToInfoMap.containsKey(scriptFile);
    }

    public ScriptInfo getExistingScriptInfo(ResourceFile script) {
        if (script == null) {
            return null;
        }
        ScriptInfo info = this.scriptFileToInfoMap.get(script);
        if (info == null) {
            String error = (script.exists() ? "" : "non") + "existing script" + script.toString() + " is missing expected ScriptInfo";
            Msg.showError(GhidraScriptInfoManager.class, null, (String)"ScriptInfo lookup", (Object)error);
        }
        return info;
    }

    public ScriptInfo getExistingScriptInfo(String scriptName) {
        List<ResourceFile> matchingFiles = this.scriptNameToFilesMap.get(scriptName);
        if (matchingFiles == null || matchingFiles.isEmpty()) {
            return null;
        }
        return this.scriptFileToInfoMap.get(matchingFiles.get(0));
    }

    public boolean alreadyExists(String scriptName) {
        return this.getExistingScriptInfo(scriptName) != null;
    }

    private void markAnyDuplicates(List<ResourceFile> files) {
        boolean isDuplicate = files.size() > 1;
        files.forEach(f -> this.scriptFileToInfoMap.get(f).setDuplicate(isDuplicate));
    }

    public void refreshDuplicates() {
        this.scriptNameToFilesMap.values().forEach(files -> {
            boolean isDuplicate = files.size() > 1;
            files.forEach(file -> this.scriptFileToInfoMap.get(file).setDuplicate(isDuplicate));
        });
    }

    public ScriptInfo findScriptInfoByName(String scriptName) {
        List<ResourceFile> matchingFiles = this.scriptNameToFilesMap.get(scriptName);
        if (matchingFiles != null && !matchingFiles.isEmpty()) {
            ScriptInfo info = this.scriptFileToInfoMap.get(matchingFiles.get(0));
            if (matchingFiles.size() > 1) {
                Msg.warn(GhidraScriptInfoManager.class, (Object)("Found duplicate scripts for name: " + scriptName + ".  Binding to script: " + String.valueOf(info.getSourceFile())));
            }
            return info;
        }
        return null;
    }
}

