/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.GhidraScriptProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public abstract class AbstractPythonScriptProvider
extends GhidraScriptProvider {
    private static final Pattern BLOCK_COMMENT = Pattern.compile("'''");

    @Override
    public abstract String getDescription();

    @Override
    public abstract String getRuntimeEnvironmentName();

    @Override
    public abstract GhidraScript getScriptInstance(ResourceFile var1, PrintWriter var2) throws GhidraScriptLoadException;

    @Override
    public void createNewScript(ResourceFile newScript, String category) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(newScript.getFile(false)));){
            this.writeHeader(writer, category);
            writer.println("");
            this.writeBody(writer);
            writer.println("");
        }
    }

    @Override
    public Pattern getBlockCommentStart() {
        return BLOCK_COMMENT;
    }

    @Override
    public Pattern getBlockCommentEnd() {
        return BLOCK_COMMENT;
    }

    @Override
    public String getCommentCharacter() {
        return "#";
    }

    @Override
    protected String getCertifyHeaderStart() {
        return "## ###";
    }

    @Override
    protected String getCertificationBodyPrefix() {
        return "#";
    }

    @Override
    protected String getCertifyHeaderEnd() {
        return "##";
    }

    @Override
    public String getExtension() {
        return ".py";
    }
}

