/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.widgets.OptionDialog;
import ghidra.app.events.FirstTimeAnalyzedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.navigation.ProgramStartingLocationOptions;
import ghidra.app.services.GoToService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Swing;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.jdom.Element;
import org.jdom.JDOMException;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Determines the starting location when a program is opened.", description="This plugin watches for new programs being opened and determines the best starting location for the listing view.  It is also responsible for storing and restoring the program's last listing location when reopened.", servicesRequired={GoToService.class}, eventsConsumed={FirstTimeAnalyzedPluginEvent.class})
public class ProgramStartingLocationPlugin
extends ProgramPlugin {
    private static final String LAST_LOCATION_PROPERTY = "LAST_PROGRAM_LOCATION";
    private ProgramStartingLocationOptions startOptions;
    private WeakHashMap<Program, ProgramLocation> currentLocationsMap = new WeakHashMap();
    private WeakHashMap<Program, ProgramLocation> startLocationsMap = new WeakHashMap();
    private WeakHashMap<Program, NonActiveProgramState> programStateMap = new WeakHashMap();

    public ProgramStartingLocationPlugin(PluginTool tool) {
        super(tool);
        this.startOptions = new ProgramStartingLocationOptions(tool);
    }

    @Override
    public void processEvent(PluginEvent event) {
        FirstTimeAnalyzedPluginEvent ev;
        Program program;
        super.processEvent(event);
        if (event instanceof FirstTimeAnalyzedPluginEvent && (program = (ev = (FirstTimeAnalyzedPluginEvent)event).getProgram()) != null) {
            Swing.runLater(() -> this.firstAnalysisCompleted(program));
        }
    }

    private void firstAnalysisCompleted(Program program) {
        if (program.equals((Object)this.currentProgram)) {
            this.processFirstAnalysisCompleted();
        } else {
            this.programStateMap.put(program, NonActiveProgramState.FIRST_ANALYSIS_COMPLETED);
        }
    }

    @Override
    protected void programOpened(Program program) {
        if (this.tool.isRestoringDataState()) {
            this.programStateMap.put(program, NonActiveProgramState.RESTORED);
        } else {
            this.programStateMap.put(program, NonActiveProgramState.NEWLY_OPENED);
        }
    }

    @Override
    protected void programClosed(Program program) {
        ProgramLocation lastLocation = this.currentLocationsMap.remove(program);
        if (lastLocation == null) {
            return;
        }
        ProgramUserData programUserData = program.getProgramUserData();
        SaveState saveState = new SaveState("Last_Location");
        lastLocation.saveState(saveState);
        String xmlString = XmlUtilities.toString((Element)saveState.saveToXml());
        programUserData.setStringProperty(LAST_LOCATION_PROPERTY, xmlString);
        this.programStateMap.remove(program);
        this.currentLocationsMap.remove(program);
    }

    @Override
    protected void postProgramActivated(Program program) {
        NonActiveProgramState state = this.programStateMap.remove(program);
        if (state == NonActiveProgramState.NEWLY_OPENED) {
            this.setStartingLocationForNewProgram();
        } else if (state == NonActiveProgramState.FIRST_ANALYSIS_COMPLETED) {
            this.processFirstAnalysisCompleted();
        }
    }

    private void processFirstAnalysisCompleted() {
        boolean shouldAskToRepostion = this.startOptions.shouldAskToRepostionAfterAnalysis();
        boolean autoRepositionIfNotMoved = this.startOptions.shouldAutoRepositionIfNotMoved();
        if (!shouldAskToRepostion && !autoRepositionIfNotMoved) {
            return;
        }
        Symbol symbol = this.findStartingSymbol(this.currentProgram);
        if (symbol == null) {
            return;
        }
        if (this.currentLocation != null && this.currentLocation.getAddress().equals((Object)symbol.getAddress())) {
            return;
        }
        if (autoRepositionIfNotMoved && this.isProgramAtStartingLocation()) {
            this.gotoLocation(symbol.getProgramLocation());
        } else if (shouldAskToRepostion && this.askToPositionProgram(symbol)) {
            this.gotoLocation(symbol.getProgramLocation());
        }
    }

    private boolean askToPositionProgram(Symbol symbol) {
        int result = OptionDialog.showYesNoDialog(null, (String)"Reposition Program?", (String)("Analysis found the symbol \"" + symbol.getName() + "\".  Would you like to go to that symbol?"));
        return result == 1;
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        if (loc != null) {
            Program program = loc.getProgram();
            this.currentLocationsMap.put(program, loc);
            if (!this.startLocationsMap.containsKey(program)) {
                this.startLocationsMap.put(program, loc);
            }
        }
    }

    private void setStartingLocationForNewProgram() {
        if (this.currentProgram == null) {
            return;
        }
        ProgramLocation location = this.getStartingProgramLocation(this.currentProgram);
        if (location != null) {
            this.gotoLocation(location);
            this.startLocationsMap.put(this.currentProgram, location);
        }
    }

    private void gotoLocation(ProgramLocation location) {
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        gotoService.goTo(location);
    }

    private boolean isProgramAtStartingLocation() {
        ProgramLocation startLocation = this.startLocationsMap.get(this.currentProgram);
        if (startLocation == null || this.currentLocation == null) {
            return true;
        }
        return startLocation.getAddress().equals((Object)this.currentLocation.getAddress());
    }

    private ProgramLocation getStartingProgramLocation(Program program) {
        switch (this.startOptions.getStartLocationType()) {
            case LAST_LOCATION: {
                ProgramLocation lastLocation = this.getLastSavedLocation(program);
                if (lastLocation != null) {
                    return lastLocation;
                }
            }
            case SYMBOL_NAME: {
                Symbol symbol = this.findStartingSymbol(program);
                if (symbol != null) {
                    return symbol.getProgramLocation();
                }
            }
            case LOWEST_CODE_BLOCK: {
                return this.findLowestCodeBlockLocation(program);
            }
        }
        return null;
    }

    private ProgramLocation getLastSavedLocation(Program program) {
        ProgramUserData programUserData = program.getProgramUserData();
        String value = programUserData.getStringProperty(LAST_LOCATION_PROPERTY, null);
        if (value == null) {
            return null;
        }
        try {
            Element element = XmlUtilities.fromString((String)value);
            SaveState saveState = new SaveState(element);
            return ProgramLocation.getLocation((Program)program, (SaveState)saveState);
        }
        catch (IOException | JDOMException e) {
            return null;
        }
    }

    private Symbol findStartingSymbol(Program program) {
        List<String> symbolNames = this.startOptions.getStartingSymbolNames();
        boolean useUnderscores = this.startOptions.useUnderscorePrefixes();
        for (String symbolName : symbolNames) {
            Symbol symbol = this.findSymbol(program, symbolName, useUnderscores);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    private ProgramLocation findLowestCodeBlockLocation(Program program) {
        AddressSetView executeSet = program.getMemory().getExecuteSet();
        if (executeSet.isEmpty()) {
            return null;
        }
        return new ProgramLocation(program, executeSet.getMinAddress());
    }

    private Symbol findSymbol(Program program, String symbolName, boolean useUnderscores) {
        Symbol symbol = this.findSymbol(program, symbolName);
        if (symbol != null) {
            return symbol;
        }
        if (!useUnderscores) {
            return null;
        }
        symbol = this.findSymbol(program, "_" + symbolName);
        if (symbol != null) {
            return symbol;
        }
        return this.findSymbol(program, "__" + symbolName);
    }

    private Symbol findSymbol(Program program, String symbolName) {
        SymbolTable symbolTable = program.getSymbolTable();
        List symbols = symbolTable.getLabelOrFunctionSymbols(symbolName, null);
        if (symbols.isEmpty()) {
            return null;
        }
        if (symbols.size() > 1) {
            Collections.sort(symbols, (s1, s2) -> s1.getAddress().compareTo((Object)s2.getAddress()));
        }
        return (Symbol)symbols.get(0);
    }

    protected void dispose() {
        super.dispose();
        this.startOptions.dispose();
    }

    public static enum NonActiveProgramState {
        NEWLY_OPENED,
        RESTORED,
        FIRST_ANALYSIS_COMPLETED;

    }
}

