/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.plugin.core.function.ThunkReferenceAddressDialog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.HelpLocation;

class EditThunkFunctionAction
extends ProgramContextAction {
    FunctionPlugin funcPlugin;

    public EditThunkFunctionAction(FunctionPlugin plugin) {
        super("Set Thunked Function", plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Set Thunked Function..."}, null, "FunctionThunk"));
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "ThunkFunctions"));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ProgramActionContext context) {
        CreateThunkFunctionCmd cmd;
        Function func;
        Program program = context.getProgram();
        FunctionManager functionMgr = program.getFunctionManager();
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            func = functionMgr.getFunctionAt(listingContext.getAddress());
        } else if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            Symbol symbol = symbolContext.getFirstSymbol();
            if (symbol == null) {
                return;
            }
            func = (Function)symbol.getObject();
        } else {
            throw new RuntimeException("Invalid context for action");
        }
        if (func == null) {
            return;
        }
        Address funcEntry = func.getEntryPoint();
        Function refFunc = func.getThunkedFunction(false);
        Symbol refSymbol = null;
        if (refFunc == null) {
            Address thunkAddr = CreateThunkFunctionCmd.getThunkedAddr(program, funcEntry, false);
            if (thunkAddr != null) {
                refSymbol = program.getSymbolTable().getPrimarySymbol(thunkAddr);
            }
        } else {
            refSymbol = refFunc.getSymbol();
        }
        ThunkReferenceAddressDialog dialog = new ThunkReferenceAddressDialog(this.funcPlugin.getTool());
        dialog.showDialog(program, funcEntry, refSymbol);
        Symbol referencedSymbol = dialog.getSymbol();
        Address referencedFunctionAddr = dialog.getAddress();
        if (referencedSymbol != null) {
            cmd = new CreateThunkFunctionCmd(funcEntry, null, referencedSymbol);
        } else if (referencedFunctionAddr != null) {
            cmd = new CreateThunkFunctionCmd(funcEntry, null, referencedFunctionAddr);
        } else {
            return;
        }
        this.funcPlugin.execute(context.getProgram(), cmd);
    }

    @Override
    protected boolean isEnabledForContext(ProgramActionContext context) {
        Function func;
        Program program = context.getProgram();
        if (program == null) {
            return false;
        }
        FunctionManager functionMgr = program.getFunctionManager();
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            func = functionMgr.getFunctionAt(listingContext.getAddress());
        } else if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            if (symbolContext.getSymbolCount() != 1) {
                return false;
            }
            Symbol s = symbolContext.getFirstSymbol();
            if (s == null || s.isExternal() || s.getSymbolType() != SymbolType.FUNCTION) {
                return false;
            }
            func = (Function)s.getObject();
        } else {
            return false;
        }
        return func != null;
    }
}

