/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.bookmark.BookmarkPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;

class AddBookmarkAction
extends DockingAction {
    BookmarkPlugin plugin;

    AddBookmarkAction(BookmarkPlugin plugin) {
        super("Add Bookmark", plugin.getName());
        this.plugin = plugin;
        this.setDescription("Add Notes bookmark to current location");
        this.setPopupMenuData(new MenuData(new String[]{"Bookmark..."}, null, "Bookmark"));
        this.setKeyBindingData(new KeyBindingData(68, 128));
    }

    public void actionPerformed(ActionContext context) {
        this.plugin.showAddBookmarkDialog(this.getAddress(context), this.getProgram(context));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context == null) {
            return false;
        }
        return this.getAddress(context) != null && this.getProgram(context) == this.plugin.getCurrentProgram();
    }

    private Address getAddress(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (MarkerLocation.class.isAssignableFrom(contextObject.getClass())) {
            return ((MarkerLocation)contextObject).getAddr();
        }
        if (context instanceof ListingActionContext) {
            return ((ListingActionContext)context).getAddress();
        }
        return null;
    }

    private Program getProgram(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (MarkerLocation.class.isAssignableFrom(contextObject.getClass())) {
            return ((MarkerLocation)contextObject).getProgram();
        }
        if (context instanceof ListingActionContext) {
            return ((ListingActionContext)context).getProgram();
        }
        return null;
    }
}

