/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class PackedEncode
implements Encoder {
    protected OutputStream outStream;

    protected void writeHeader(int header, int id) throws IOException {
        if (id > 31) {
            header |= 0x20;
            int extendByte = id & 0x7F | 0x80;
            this.outStream.write(header |= id >> 7);
            this.outStream.write(extendByte);
        } else {
            this.outStream.write(header |= id);
        }
    }

    protected void writeInteger(int typeByte, long val) throws IOException {
        int sa;
        int lenCode;
        if (val <= 0L) {
            if (val == 0L) {
                lenCode = 0;
                sa = -1;
            } else {
                lenCode = 10;
                sa = 63;
            }
        } else if (val < 0x800000000L) {
            if (val < 0x200000L) {
                if (val < 128L) {
                    lenCode = 1;
                    sa = 0;
                } else if (val < 16384L) {
                    lenCode = 2;
                    sa = 7;
                } else {
                    lenCode = 3;
                    sa = 14;
                }
            } else if (val < 0x10000000L) {
                lenCode = 4;
                sa = 21;
            } else {
                lenCode = 5;
                sa = 28;
            }
        } else if (val < 0x2000000000000L) {
            if (val < 0x40000000000L) {
                lenCode = 6;
                sa = 35;
            } else {
                lenCode = 7;
                sa = 42;
            }
        } else if (val < 0x100000000000000L) {
            lenCode = 8;
            sa = 49;
        } else {
            lenCode = 9;
            sa = 56;
        }
        this.outStream.write(typeByte |= lenCode);
        while (sa >= 0) {
            long piece = val >>> sa & 0x7FL;
            this.outStream.write((int)(piece |= 0x80L));
            sa -= 7;
        }
    }

    public PackedEncode() {
        this.outStream = null;
    }

    public PackedEncode(OutputStream stream) {
        this.outStream = stream;
    }

    @Override
    public void openElement(ElementId elemId) throws IOException {
        this.writeHeader(64, elemId.id());
    }

    @Override
    public void closeElement(ElementId elemId) throws IOException {
        this.writeHeader(128, elemId.id());
    }

    @Override
    public void writeBool(AttributeId attribId, boolean val) throws IOException {
        this.writeHeader(192, attribId.id());
        int typeByte = val ? 17 : 16;
        this.outStream.write(typeByte);
    }

    @Override
    public void writeSignedInteger(AttributeId attribId, long val) throws IOException {
        long num;
        int typeByte;
        this.writeHeader(192, attribId.id());
        if (val < 0L) {
            typeByte = 48;
            num = -val;
        } else {
            typeByte = 32;
            num = val;
        }
        this.writeInteger(typeByte, num);
    }

    @Override
    public void writeUnsignedInteger(AttributeId attribId, long val) throws IOException {
        this.writeHeader(192, attribId.id());
        this.writeInteger(64, val);
    }

    @Override
    public void writeString(AttributeId attribId, String val) throws IOException {
        byte[] bytes = val.getBytes();
        this.writeHeader(192, attribId.id());
        this.writeInteger(112, bytes.length);
        this.outStream.write(bytes);
    }

    @Override
    public void writeStringIndexed(AttributeId attribId, int index, String val) throws IOException {
        byte[] bytes = val.getBytes();
        this.writeHeader(192, attribId.id() + index);
        this.writeInteger(112, bytes.length);
        this.outStream.write(bytes);
    }

    @Override
    public void writeSpace(AttributeId attribId, AddressSpace spc) throws IOException {
        this.writeHeader(192, attribId.id());
        switch (spc.getType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                this.writeInteger(80, spc.getUnique());
                break;
            }
            case 11: {
                this.outStream.write(97);
                break;
            }
            case 5: {
                this.outStream.write(96);
                break;
            }
            default: {
                throw new IOException("Cannot marshal address space: " + spc.getName());
            }
        }
    }

    @Override
    public void writeSpace(AttributeId attribId, int index, String name) throws IOException {
        this.writeHeader(192, attribId.id());
        this.writeInteger(80, index);
    }

    @Override
    public void writeOpcode(AttributeId attribId, OpCode opcode) throws IOException {
        this.writeHeader(192, attribId.id());
        this.writeInteger(32, opcode.ordinal());
    }

    public OutputStream getOutputStream() {
        return this.outStream;
    }
}

