/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class FollowFlow {
    private Program program;
    private AddressSetView initialAddresses;
    private boolean followAllFlow = true;
    private boolean followComputedCall = true;
    private boolean followConditionalCall = true;
    private boolean followUnconditionalCall = true;
    private boolean followComputedJump = true;
    private boolean followConditionalJump = true;
    private boolean followUnconditionalJump = true;
    private boolean followPointers = true;
    private boolean followIntoFunction = true;
    private boolean includeData = true;
    private AddressSpace restrictedAddressSpace = null;
    private Address nextSymbolAddr;

    public FollowFlow(Program program, AddressSetView addressSet, FlowType[] doNotFollow) {
        this.program = program;
        this.initialAddresses = addressSet;
        this.updateFollowFlags(doNotFollow);
    }

    public FollowFlow(Program program, AddressSetView addressSet, FlowType[] doNotFollow, boolean followIntoFunctions) {
        this(program, addressSet, doNotFollow);
        this.followIntoFunction = followIntoFunctions;
    }

    public FollowFlow(Program program, AddressSet addressSet, FlowType[] doNotFollow, boolean followIntoFunctions, boolean includeData) {
        this(program, addressSet, doNotFollow, followIntoFunctions);
        this.includeData = includeData;
    }

    public FollowFlow(Program program, Address address, FlowType[] doNotFollow, boolean followIntoFunctions, boolean includeData, boolean restrictSingleAddressSpace) {
        this(program, new AddressSet(address, address), doNotFollow, followIntoFunctions);
        if (restrictSingleAddressSpace) {
            this.restrictedAddressSpace = address.getAddressSpace();
        }
        this.includeData = includeData;
    }

    private void updateFollowFlags(FlowType[] doNotFollowFlows) {
        if (doNotFollowFlows != null && doNotFollowFlows.length > 0) {
            this.followAllFlow = false;
            for (FlowType flowType : doNotFollowFlows) {
                if (flowType.equals(RefType.COMPUTED_CALL)) {
                    this.followComputedCall = false;
                    continue;
                }
                if (flowType.equals(RefType.CONDITIONAL_CALL)) {
                    this.followConditionalCall = false;
                    continue;
                }
                if (flowType.equals(RefType.UNCONDITIONAL_CALL)) {
                    this.followUnconditionalCall = false;
                    continue;
                }
                if (flowType.equals(RefType.COMPUTED_JUMP)) {
                    this.followComputedJump = false;
                    continue;
                }
                if (flowType.equals(RefType.CONDITIONAL_JUMP)) {
                    this.followConditionalJump = false;
                    continue;
                }
                if (flowType.equals(RefType.UNCONDITIONAL_JUMP)) {
                    this.followUnconditionalJump = false;
                    continue;
                }
                if (!flowType.equals(RefType.INDIRECTION)) continue;
                this.followPointers = false;
            }
        }
    }

    private AddressSet getAddressFlow(TaskMonitor monitor, AddressSetView startAddresses, boolean forward) {
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        AddressSet addressSet = new AddressSet();
        AddressSet coveredAddrs = new AddressSet();
        if (startAddresses == null || startAddresses.getNumAddresses() <= 0L) {
            return addressSet;
        }
        Listing listing = this.program.getListing();
        CodeUnitIterator cuIter = listing.getCodeUnits(startAddresses, true);
        while (!monitor.isCancelled() && cuIter.hasNext()) {
            CodeUnit codeUnit = cuIter.next();
            coveredAddrs.addRange(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
            this.getCodeUnitFlow(monitor, startAddresses, addressSet, codeUnit, forward);
        }
        AddressSet addrs = new AddressSet(startAddresses);
        addrs.delete(coveredAddrs);
        AddressIterator addrIter = addrs.getAddresses(true);
        while (!monitor.isCancelled() && addrIter.hasNext()) {
            Address addr = addrIter.next();
            if (addressSet.contains(addr)) continue;
            Data data = listing.getDefinedDataContaining(addr);
            if (forward) {
                this.followCode(monitor, addressSet, data, addr);
                continue;
            }
            this.followCodeBack(monitor, addressSet, data, addr);
        }
        if (monitor.isCancelled()) {
            return new AddressSet();
        }
        return addressSet;
    }

    private void getCodeUnitFlow(TaskMonitor monitor, AddressSetView startAddresses, AddressSet flowAddressSet, CodeUnit codeUnit, boolean forward) {
        if (codeUnit instanceof Data) {
            this.getIndirectCodeFlow(monitor, startAddresses, flowAddressSet, (Data)codeUnit, forward);
        } else if (codeUnit instanceof Instruction) {
            this.getInstructionFlow(monitor, flowAddressSet, (Instruction)codeUnit, forward);
        }
    }

    private void getInstructionFlow(TaskMonitor monitor, AddressSet flowAddressSet, Instruction instruction, boolean forward) {
        if (forward) {
            this.followCode(monitor, flowAddressSet, instruction, null);
        } else {
            this.followCodeBack(monitor, flowAddressSet, instruction, null);
        }
    }

    private void getIndirectCodeFlow(TaskMonitor monitor, AddressSetView startAddresses, AddressSet flowAddressSet, Data data, boolean forward) {
        Address addr;
        if (!data.isDefined()) {
            return;
        }
        Address maxAddr = data.getMaxAddress();
        AddressIterator addrIter = startAddresses.getAddresses(data.getMinAddress(), true);
        while (!monitor.isCancelled() && addrIter.hasNext() && (addr = addrIter.next()).compareTo(maxAddr) <= 0) {
            if (flowAddressSet.contains(addr)) continue;
            if (forward) {
                this.followCode(monitor, flowAddressSet, data, addr);
                continue;
            }
            this.followCodeBack(monitor, flowAddressSet, data, addr);
        }
    }

    private void followCode(TaskMonitor monitor, AddressSet flowAddressSet, CodeUnit codeUnit, Address dataAddr) {
        if (codeUnit == null) {
            return;
        }
        Stack<CodeUnit> instructionStack = new Stack<CodeUnit>();
        if (codeUnit instanceof Data) {
            this.followData(instructionStack, flowAddressSet, (Data)codeUnit, dataAddr);
        } else {
            instructionStack.push(codeUnit);
        }
        Address start_addr = codeUnit.getMinAddress();
        if (!this.followIntoFunction) {
            try {
                this.nextSymbolAddr = this.getNextSymbolAddress(start_addr.add(1L), this.nextSymbolAddr);
            }
            catch (AddressOutOfBoundsException e) {
                this.nextSymbolAddr = null;
            }
        }
        AddressSet delaySlotSet = new AddressSet();
        while (!monitor.isCancelled() && !instructionStack.isEmpty()) {
            codeUnit = instructionStack.pop();
            if (!(codeUnit instanceof Instruction)) {
                if (!this.includeData) continue;
                flowAddressSet.addRange(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
                continue;
            }
            Instruction currentInstr = (Instruction)codeUnit;
            Address currentAddress = currentInstr.getMinAddress();
            if (flowAddressSet.contains(currentAddress)) continue;
            Instruction instr = currentInstr;
            Address end = instr.getMaxAddress();
            int delaySlotDepth = instr.getDelaySlotDepth();
            for (int i = 0; i < delaySlotDepth && (instr = instr.getNext()) != null; ++i) {
                delaySlotSet.add(instr.getMinAddress(), instr.getMaxAddress());
            }
            flowAddressSet.addRange(currentInstr.getMinAddress(), end);
            this.followInstruction(instructionStack, flowAddressSet, currentInstr);
        }
        flowAddressSet.add(delaySlotSet);
    }

    private void followCodeBack(TaskMonitor monitor, AddressSet flowAddressSet, CodeUnit codeUnit, Address dataAddress) {
        if (codeUnit == null) {
            return;
        }
        Stack<CodeUnit> codeUnitStack = new Stack<CodeUnit>();
        if (codeUnit instanceof Data) {
            this.followDataBack(codeUnitStack, flowAddressSet, (Data)codeUnit, dataAddress);
            if (dataAddress != null && !flowAddressSet.contains(dataAddress)) {
                flowAddressSet.add(dataAddress);
            }
        } else {
            codeUnitStack.push(codeUnit);
        }
        while (!monitor.isCancelled() && !codeUnitStack.isEmpty()) {
            codeUnit = codeUnitStack.pop();
            if (codeUnit instanceof Instruction) {
                Instruction currentInstr = this.getAdjustedInstruction((Instruction)codeUnit, flowAddressSet);
                if (currentInstr == null) continue;
                this.followInstructionBack(codeUnitStack, flowAddressSet, currentInstr);
                continue;
            }
            if (!(codeUnit instanceof Data)) continue;
            this.followDataBack(codeUnitStack, flowAddressSet, (Data)codeUnit, dataAddress);
        }
    }

    private Instruction getAdjustedInstruction(Instruction currentInstr, AddressSet flowAddressSet) {
        Address currentAddress = currentInstr.getMinAddress();
        if (flowAddressSet.contains(currentAddress)) {
            return null;
        }
        Instruction instr = currentInstr;
        while (instr.isInDelaySlot()) {
            Address fallFrom = instr.getFallFrom();
            if (fallFrom == null) {
                flowAddressSet.addRange(instr.getMinAddress(), currentInstr.getMaxAddress());
                break;
            }
            instr = this.program.getListing().getInstructionContaining(fallFrom);
        }
        currentInstr = instr;
        Address end = instr.getMaxAddress();
        for (int i = instr.getDelaySlotDepth(); i > 0 && (instr = instr.getNext()) != null; --i) {
            end = instr.getMaxAddress();
        }
        flowAddressSet.addRange(currentInstr.getMinAddress(), end);
        return currentInstr;
    }

    private Address getNextSymbolAddress(Address curAddr, Address curNext) {
        if (curAddr == null) {
            return null;
        }
        if (curNext == Address.NO_ADDRESS) {
            return curNext;
        }
        if (curNext == null || curNext.compareTo(curAddr) < 0) {
            Symbol symbol;
            Address addr;
            SymbolTable symbolTable = this.program.getSymbolTable();
            Memory memory = this.program.getMemory();
            SymbolIterator symbols = symbolTable.getSymbolIterator(curAddr, true);
            if (symbols.hasNext() && (addr = (symbol = symbols.next()).getAddress()).getAddressSpace().equals(curAddr.getAddressSpace()) && memory.contains(addr)) {
                return addr;
            }
            return Address.NO_ADDRESS;
        }
        return curNext;
    }

    private void followInstruction(Stack<CodeUnit> instructionStack, AddressSet flowAddressSet, Instruction currentInstr) {
        Instruction nextInstruction;
        Address nextAddress = null;
        Address[] flowAddresses = this.getFlowsFromInstruction(currentInstr);
        for (int index = 0; flowAddresses != null && index < flowAddresses.length; ++index) {
            CodeUnit nextCodeUnit;
            nextAddress = flowAddresses[index];
            if (nextAddress == null || this.restrictedAddressSpace != null && this.restrictedAddressSpace != nextAddress.getAddressSpace() || (nextCodeUnit = this.program.getListing().getCodeUnitContaining(nextAddress)) == null) continue;
            if (nextCodeUnit instanceof Data && this.includeData) {
                this.followData(instructionStack, flowAddressSet, (Data)nextCodeUnit, nextAddress);
                continue;
            }
            instructionStack.push(nextCodeUnit);
        }
        nextAddress = currentInstr.getFallThrough();
        if (!this.followIntoFunction) {
            Symbol symbol;
            this.nextSymbolAddr = this.getNextSymbolAddress(nextAddress, this.nextSymbolAddr);
            if (this.nextSymbolAddr != null && this.nextSymbolAddr.equals(nextAddress) && (symbol = this.program.getSymbolTable().getPrimarySymbol(nextAddress)).getSymbolType() == SymbolType.FUNCTION) {
                nextAddress = null;
            }
        }
        if (nextAddress != null && (this.restrictedAddressSpace == null || this.restrictedAddressSpace == nextAddress.getAddressSpace()) && (nextInstruction = this.program.getListing().getInstructionAt(nextAddress)) != null) {
            instructionStack.push(nextInstruction);
        }
    }

    private void followInstructionBack(Stack<CodeUnit> instructionStack, AddressSet flowAddressSet, Instruction currentInstr) {
        Instruction fromInstruction;
        Symbol primarySymbol;
        if (!this.followIntoFunction && (primarySymbol = currentInstr.getPrimarySymbol()).getSymbolType() == SymbolType.FUNCTION) {
            return;
        }
        Address fromAddress = null;
        Address[] flowFromAddresses = this.getFlowsAndPointersToInstruction(currentInstr);
        for (int index = 0; flowFromAddresses != null && index < flowFromAddresses.length; ++index) {
            CodeUnit nextCodeUnit;
            fromAddress = flowFromAddresses[index];
            if (fromAddress == null || (nextCodeUnit = this.program.getListing().getCodeUnitContaining(fromAddress)) == null) continue;
            if (nextCodeUnit instanceof Data) {
                Data data = (Data)nextCodeUnit;
                Address minAddress = data.getMinAddress();
                int offset = (int)fromAddress.subtract(minAddress);
                Data primitive = data.getPrimitiveAt(offset);
                if (primitive == null || !primitive.isPointer()) continue;
                this.followDataBack(instructionStack, flowAddressSet, (Data)nextCodeUnit, fromAddress);
                continue;
            }
            instructionStack.push(nextCodeUnit);
        }
        this.getFlowsToPreceedingDelaySlots(currentInstr, instructionStack, flowAddressSet);
        fromAddress = currentInstr.getFallFrom();
        if (fromAddress != null && (fromInstruction = this.program.getListing().getInstructionAt(fromAddress)) != null) {
            instructionStack.push(fromInstruction);
        }
    }

    private void getFlowsToPreceedingDelaySlots(Instruction currentInstruction, Stack<CodeUnit> codeUnitStack, AddressSet flowAddressSet) {
        Instruction instruction = currentInstruction;
        boolean inDelaySlot = false;
        ArrayList<Instruction> list = new ArrayList<Instruction>();
        int alignment = this.program.getLanguage().getInstructionAlignment();
        if (alignment < 1) {
            alignment = 1;
        }
        Listing listing = this.program.getListing();
        do {
            try {
                instruction = listing.getInstructionContaining(instruction.getMinAddress().subtractNoWrap(alignment));
                if (instruction == null) break;
                inDelaySlot = instruction.isInDelaySlot();
                if (!inDelaySlot) continue;
                this.handleFlowsIntoDelaySlot(instruction, codeUnitStack, flowAddressSet, list, listing);
            }
            catch (AddressOverflowException e) {
                return;
            }
        } while (inDelaySlot);
    }

    private void handleFlowsIntoDelaySlot(Instruction instruction, Stack<CodeUnit> codeUnitStack, AddressSet flowAddressSet, List<Instruction> delaySlotList, Listing listing) {
        delaySlotList.add(instruction);
        boolean foundFlowToDelaySlot = false;
        Address[] flowFromAddresses = this.getFlowsAndPointersToInstruction(instruction);
        for (Address fromAddress : flowFromAddresses) {
            CodeUnit codeUnit = listing.getCodeUnitAt(fromAddress);
            if (codeUnit == null) continue;
            codeUnitStack.add(codeUnit);
            foundFlowToDelaySlot = true;
        }
        if (foundFlowToDelaySlot) {
            for (Instruction delaySlotInstruction : delaySlotList) {
                flowAddressSet.add(delaySlotInstruction.getMinAddress(), delaySlotInstruction.getMaxAddress());
            }
            delaySlotList.clear();
        }
    }

    private boolean shouldFollowFlow(FlowType currentFlowType) {
        boolean shouldFollowFlow = true;
        shouldFollowFlow = !(!this.followAllFlow && (currentFlowType.equals(RefType.COMPUTED_CALL) && !this.followComputedCall || currentFlowType.equals(RefType.COMPUTED_JUMP) && !this.followComputedJump || currentFlowType.equals(RefType.CONDITIONAL_JUMP) && !this.followConditionalJump || currentFlowType.equals(RefType.UNCONDITIONAL_JUMP) && !this.followUnconditionalJump || currentFlowType.equals(RefType.CONDITIONAL_CALL) && !this.followConditionalCall || currentFlowType.equals(RefType.UNCONDITIONAL_CALL) && !this.followUnconditionalCall || currentFlowType.equals(RefType.INDIRECTION) && !this.followPointers));
        return shouldFollowFlow;
    }

    private Address[] getFlowsFromInstruction(Instruction instr) {
        Reference[] refsFrom = instr.getReferencesFrom();
        int length = refsFrom.length;
        ArrayList<Address> list = new ArrayList<Address>(length);
        for (int i = 0; i < length; ++i) {
            SymbolTable symbolTable;
            Symbol primarySymbol;
            RefType refType = refsFrom[i].getReferenceType();
            if (!refType.isFlow() || !this.shouldFollowFlow((FlowType)refType)) continue;
            Address toAddr = refsFrom[i].getToAddress();
            if (!this.followIntoFunction && (primarySymbol = (symbolTable = this.program.getSymbolTable()).getPrimarySymbol(toAddr)).getSymbolType() == SymbolType.FUNCTION) continue;
            list.add(toAddr);
        }
        return list.toArray(new Address[list.size()]);
    }

    private Address[] getFlowsAndPointersToInstruction(Instruction instr) {
        SymbolTable symbolTable;
        Symbol primarySymbol;
        if (!this.followIntoFunction && (primarySymbol = (symbolTable = this.program.getSymbolTable()).getPrimarySymbol(instr.getMinAddress())) != null && primarySymbol.getSymbolType() == SymbolType.FUNCTION) {
            return new Address[0];
        }
        Listing listing = this.program.getListing();
        ArrayList<Address> list = new ArrayList<Address>();
        ReferenceIterator referenceIteratorTo = instr.getReferenceIteratorTo();
        for (Reference reference : referenceIteratorTo) {
            Address fromAddress;
            RefType refType = reference.getReferenceType();
            if (this.followPointers && refType.isData()) {
                Address minAddress;
                int offset;
                Data primitive;
                fromAddress = reference.getFromAddress();
                Data data = listing.getDataContaining(fromAddress);
                if (data == null || (primitive = data.getPrimitiveAt(offset = (int)fromAddress.subtract(minAddress = data.getMinAddress()))) == null || !primitive.isPointer()) continue;
                list.add(fromAddress);
                continue;
            }
            if (!refType.isFlow() || !this.shouldFollowFlow((FlowType)refType)) continue;
            fromAddress = reference.getFromAddress();
            list.add(fromAddress);
        }
        return list.toArray(new Address[list.size()]);
    }

    private void followData(Stack<CodeUnit> instructionStack, AddressSet flowAddressSet, Data data, Address addr) {
        Address min;
        if (flowAddressSet.contains(addr)) {
            return;
        }
        Address max = min = addr;
        int offset = (int)addr.subtract(data.getMinAddress());
        Data primitive = data.getPrimitiveAt(offset);
        if (primitive != null) {
            max = primitive.getMaxAddress();
            if (this.followPointers && primitive.isPointer()) {
                ReferenceManager referenceManager = this.program.getReferenceManager();
                Reference[] memRefs = referenceManager.getReferencesFrom(addr);
                boolean foundRef = false;
                for (Reference memRef : memRefs) {
                    RefType rt = memRef.getReferenceType();
                    if (!rt.isData() || !this.pushInstruction(instructionStack, memRef.getToAddress())) continue;
                    foundRef = true;
                }
                if (!foundRef) {
                    this.pushInstruction(instructionStack, (Address)primitive.getValue());
                }
            }
        }
        flowAddressSet.addRange(min, max);
    }

    private void followDataBack(Stack<CodeUnit> instructionStack, AddressSet flowAddressSet, Data data, Address addr) {
        if (flowAddressSet.contains(addr)) {
            return;
        }
        this.addPointerToFlow(flowAddressSet, data, addr);
        ReferenceManager referenceManager = this.program.getReferenceManager();
        ReferenceIterator referenceIteratorTo = referenceManager.getReferencesTo(addr);
        for (Reference reference : referenceIteratorTo) {
            RefType refType = reference.getReferenceType();
            Address fromAddress = reference.getFromAddress();
            CodeUnit fromCodeUnit = this.program.getListing().getCodeUnitContaining(fromAddress);
            if (!refType.equals(RefType.INDIRECTION) || !(fromCodeUnit instanceof Instruction)) continue;
            instructionStack.add(fromCodeUnit);
        }
    }

    private void addPointerToFlow(AddressSet flowAddressSet, Data data, Address addr) {
        int offset = (int)addr.subtract(data.getMinAddress());
        Data primitive = data.getPrimitiveAt(offset);
        if (primitive != null && primitive.isPointer()) {
            flowAddressSet.addRange(primitive.getMinAddress(), primitive.getMaxAddress());
        }
    }

    private boolean pushInstruction(Stack<CodeUnit> cuStack, Address addr) {
        if (addr == null) {
            return false;
        }
        Instruction codeUnit = this.program.getListing().getInstructionAt(addr);
        if (codeUnit != null) {
            cuStack.push(codeUnit);
            return true;
        }
        return false;
    }

    public AddressSet getFlowAddressSet(TaskMonitor monitor) {
        return this.getAddressFlow(monitor, this.initialAddresses, true);
    }

    public AddressSet getFlowToAddressSet(TaskMonitor monitor) {
        return this.getAddressFlow(monitor, this.initialAddresses, false);
    }
}

