/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class ValueMapSymbol
extends ValueSymbol {
    private VectorSTL<Long> valuetable = new VectorSTL();
    private boolean tableisfilled;

    public ValueMapSymbol(Location location) {
        super(location);
    }

    public ValueMapSymbol(Location location, String nm, PatternValue pv, VectorSTL<Long> vt) {
        super(location, nm, pv);
        this.valuetable = new VectorSTL(vt);
        this.checkTableFill();
    }

    @Override
    public symbol_type getType() {
        return symbol_type.valuemap_symbol;
    }

    private void checkTableFill() {
        long min = this.patval.minValue();
        long max = this.patval.maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.valuetable.size();
        for (int i = 0; i < this.valuetable.size(); ++i) {
            if ((Long)this.valuetable.get(i) != 195935983L) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VALUEMAP_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        this.patval.encode(encoder);
        for (int i = 0; i < this.valuetable.size(); ++i) {
            encoder.openElement(SlaFormat.ELEM_VALUETAB);
            encoder.writeSignedInteger(SlaFormat.ATTRIB_VAL, (Long)this.valuetable.get(i));
            encoder.closeElement(SlaFormat.ELEM_VALUETAB);
        }
        encoder.closeElement(SlaFormat.ELEM_VALUEMAP_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VALUEMAP_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_VALUEMAP_SYM_HEAD);
    }
}

