/*
 * Decompiled with CFR 0.152.
 */
package utilities.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public final class AnnotationUtilities
extends Enum<AnnotationUtilities> {
    private static final /* synthetic */ AnnotationUtilities[] $VALUES;

    public static AnnotationUtilities[] values() {
        return (AnnotationUtilities[])$VALUES.clone();
    }

    public static AnnotationUtilities valueOf(String name) {
        return Enum.valueOf(AnnotationUtilities.class, name);
    }

    public static Set<Method> collectAnnotatedMethods(Class<? extends Annotation> annotCls, Class<?> cls) {
        HashSet<Method> defs = new HashSet<Method>();
        AnnotationUtilities.collectAnnotatedMethods(annotCls, cls, defs, new HashSet());
        return defs;
    }

    private static void collectAnnotatedMethods(Class<? extends Annotation> annotCls, Class<?> cls, Set<Method> defs, Set<Class<?>> visited) {
        if (!visited.add(cls)) {
            return;
        }
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null) {
            AnnotationUtilities.collectAnnotatedMethods(annotCls, superCls, defs, visited);
        }
        for (Class<?> superIf : cls.getInterfaces()) {
            AnnotationUtilities.collectAnnotatedMethods(annotCls, superIf, defs, visited);
        }
        AnnotationUtilities.collectAnnotatedMethodsForClass(annotCls, cls, defs);
    }

    private static void collectAnnotatedMethodsForClass(Class<? extends Annotation> annotCls, Class<?> cls, Set<Method> defs) {
        for (Method method : cls.getDeclaredMethods()) {
            Annotation annot = method.getAnnotation(annotCls);
            if (annot == null) continue;
            defs.add(method);
        }
    }

    private static /* synthetic */ AnnotationUtilities[] $values() {
        return new AnnotationUtilities[0];
    }

    static {
        $VALUES = AnnotationUtilities.$values();
    }
}

