/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.ui.LoadPdbDialog;
import utilities.util.FileUtilities;

public record WellKnownSymbolServerLocation(String location, String locationCategory, String warning, String fileOrigin) {
    public static List<WellKnownSymbolServerLocation> loadAll() {
        List pdbUrlFiles = Application.findFilesByExtensionInApplication((String)".pdburl");
        ArrayList<WellKnownSymbolServerLocation> results = new ArrayList<WellKnownSymbolServerLocation>();
        for (ResourceFile file : pdbUrlFiles) {
            try {
                List lines = FileUtilities.getLines((ResourceFile)file);
                for (String line : lines) {
                    String[] fields = line.split("\\|");
                    if (fields.length <= 1) continue;
                    results.add(new WellKnownSymbolServerLocation(fields[1], fields[0], fields.length > 2 ? fields[2] : null, file.getName()));
                }
            }
            catch (IOException e) {
                Msg.warn(WellKnownSymbolServerLocation.class, (Object)("Unable to read pdburl file: " + String.valueOf(file)));
            }
        }
        return results;
    }

    public static LoadPdbDialog.StatusText getWarningsFor(List<WellKnownSymbolServerLocation> knownSymbolServers, List<SymbolServer> symbolServers) {
        HashMap<String, String> warningsByLocation = new HashMap<String, String>();
        for (WellKnownSymbolServerLocation ssloc : knownSymbolServers) {
            if (ssloc.warning() == null || ssloc.warning().isBlank()) continue;
            warningsByLocation.put(ssloc.location(), ssloc.warning());
        }
        String warning = symbolServers.stream().filter(symbolServer -> !symbolServer.isTrusted()).map(symbolServer -> (String)warningsByLocation.get(symbolServer.getName())).filter(Objects::nonNull).distinct().collect(Collectors.joining("<br>\n"));
        return !warning.isEmpty() ? new LoadPdbDialog.StatusText(warning, MessageType.WARNING, false) : null;
    }
}

