/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import util.CollectionUtils;

public class GraphNavigator<V, E extends GEdge<V>> {
    private boolean isTopDown;

    public static <V, E extends GEdge<V>> GraphNavigator<V, E> topDownNavigator() {
        return new GraphNavigator<V, E>(true);
    }

    public static <V, E extends GEdge<V>> GraphNavigator<V, E> bottomUpNavigator() {
        return new GraphNavigator<V, E>(false);
    }

    private GraphNavigator(boolean isTopDown) {
        this.isTopDown = isTopDown;
    }

    public Collection<E> getEdges(GDirectedGraph<V, E> graph, V v) {
        if (this.isTopDown) {
            return CollectionUtils.asCollection(graph.getOutEdges(v));
        }
        return CollectionUtils.asCollection(graph.getInEdges(v));
    }

    public boolean isTopDown() {
        return this.isTopDown;
    }

    public Collection<V> getSuccessors(GDirectedGraph<V, E> graph, V v) {
        if (this.isTopDown) {
            return graph.getSuccessors(v);
        }
        return graph.getPredecessors(v);
    }

    public Collection<V> getPredecessors(GDirectedGraph<V, E> graph, V v) {
        if (this.isTopDown) {
            return CollectionUtils.asCollection(graph.getPredecessors(v));
        }
        return CollectionUtils.asCollection(graph.getSuccessors(v));
    }

    public V getEnd(E e) {
        if (this.isTopDown) {
            return e.getEnd();
        }
        return e.getStart();
    }

    public Set<V> getSources(GDirectedGraph<V, E> graph) {
        if (this.isTopDown) {
            return CollectionUtils.asSet(GraphAlgorithms.getSources(graph));
        }
        return CollectionUtils.asSet(GraphAlgorithms.getSinks(graph));
    }

    public Set<V> getSinks(GDirectedGraph<V, E> graph) {
        if (this.isTopDown) {
            return CollectionUtils.asSet(GraphAlgorithms.getSinks(graph));
        }
        return CollectionUtils.asSet(GraphAlgorithms.getSources(graph));
    }

    public List<V> getVerticesInPostOrder(GDirectedGraph<V, E> graph) {
        List postOrder = CollectionUtils.asList(GraphAlgorithms.getVerticesInPostOrder(graph, this));
        return postOrder;
    }
}

