/*
 * Decompiled with CFR 0.152.
 */
package help;

import generic.application.GenericApplicationLayout;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import help.GHelpMsg;
import help.HelpBuildUtils;
import help.validator.LinkDatabase;
import help.validator.location.HelpModuleCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import utility.application.ApplicationLayout;

public class GHelpTocValidator {
    private static final String DEBUG_SWITCH = "-debug";
    private Collection<File> helpInputDirectories = new LinkedHashSet<File>();

    public static void main(String[] args) throws Exception {
        GHelpTocValidator validator = new GHelpTocValidator();
        ApplicationConfiguration config = new ApplicationConfiguration();
        Application.initializeApplication((ApplicationLayout)new GenericApplicationLayout("Help TOC Validator", "0.1"), (ApplicationConfiguration)config);
        validator.validate(args);
    }

    private void validate(String[] args) {
        this.parseArguments(args);
        ArrayList<File> allHelp = new ArrayList<File>(this.helpInputDirectories);
        HelpModuleCollection help = HelpModuleCollection.fromFiles(allHelp);
        LinkDatabase linkDatabase = new LinkDatabase(help);
        linkDatabase.validateAllTOCs();
    }

    private void parseArguments(String[] args) {
        boolean debugEnabled = false;
        for (String opt : args) {
            if (opt.equals(DEBUG_SWITCH)) {
                debugEnabled = true;
                continue;
            }
            if (opt.startsWith("-")) {
                GHelpMsg.error("Unknown option " + opt);
                System.exit(1);
                continue;
            }
            this.helpInputDirectories.add(new File(opt));
        }
        HelpBuildUtils.debug = debugEnabled;
        if (this.helpInputDirectories.size() == 0) {
            GHelpMsg.error("Must specify at least one help jar file");
            System.exit(1);
        }
    }
}

