/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.DialogComponentProvider;
import docking.widgets.table.RowObjectTableModel;
import ghidra.features.bsim.gui.search.results.BSimApplyResult;
import ghidra.features.bsim.gui.search.results.BSimApplyResultsTableModel;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.table.GhidraFilterTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;

public class BSimApplyResultsDisplayDialog
extends DialogComponentProvider {
    private ServiceProvider serviceProvider;
    private Program program;
    private GhidraFilterTable<BSimApplyResult> table;

    public BSimApplyResultsDisplayDialog(ServiceProvider serviceProvider, List<BSimApplyResult> results, Program program) {
        super(BSimApplyResultsDisplayDialog.createTitle(results));
        this.setRememberSize(false);
        this.serviceProvider = serviceProvider;
        this.program = program;
        this.addWorkPanel(this.createWorkPanel(results));
        this.addOKButton();
    }

    private static String createTitle(List<BSimApplyResult> results) {
        StringBuilder builder = new StringBuilder();
        int successes = 0;
        int errors = 0;
        int ignored = 0;
        for (BSimApplyResult result : results) {
            if (result.isError()) {
                ++errors;
                continue;
            }
            if (result.isIgnored()) {
                ++ignored;
                continue;
            }
            ++successes;
        }
        builder.append("BSim Apply Results (");
        builder.append(successes);
        builder.append(" successfully applied");
        if (errors > 0) {
            builder.append(", ");
            builder.append(errors);
            builder.append(" error(s)");
        }
        if (ignored > 0) {
            builder.append(", ");
            builder.append(ignored);
            builder.append(" ignored");
        }
        builder.append(")");
        return builder.toString();
    }

    protected void okCallback() {
        this.close();
    }

    public boolean isModal() {
        return false;
    }

    private JPanel createWorkPanel(List<BSimApplyResult> results) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(1200, 400));
        BSimApplyResultsTableModel model = new BSimApplyResultsTableModel("results model", this.serviceProvider, this.program, null, results);
        this.table = new GhidraFilterTable((RowObjectTableModel)model);
        this.table.installNavigation(this.serviceProvider);
        panel.add((Component)this.table, "Center");
        return panel;
    }
}

