/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DockingActionInputBindingListener;
import docking.KeyEntryPanel;
import docking.MouseEntryTextField;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GLabel;
import generic.theme.GIcon;
import gui.event.MouseBinding;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ActionBindingPanel
extends JPanel {
    private static final String DISABLED_HINT = "Select an action";
    private KeyEntryPanel keyEntryPanel;
    private MouseEntryTextField mouseEntryField;
    private DockingActionInputBindingListener listener;

    public ActionBindingPanel(DockingActionInputBindingListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.build();
    }

    private void build() {
        this.setLayout(new BoxLayout(this, 2));
        this.keyEntryPanel = new KeyEntryPanel(20, ks -> this.listener.keyStrokeChanged(ks));
        this.keyEntryPanel.setDisabledHint(DISABLED_HINT);
        this.keyEntryPanel.setEnabled(false);
        this.mouseEntryField = new MouseEntryTextField(20, mb -> this.listener.mouseBindingChanged((MouseBinding)mb));
        this.mouseEntryField.setDisabledHint(DISABLED_HINT);
        EmptyBorderButton clearMouseButton = new EmptyBorderButton((Icon)new GIcon("icon.text.field.clear"));
        clearMouseButton.setName("Clear Mouse Binding");
        clearMouseButton.addActionListener(e -> this.mouseEntryField.clearMouseBinding());
        GLabel keyBindingLabel = new GLabel("Key Binding: ");
        JTextField tf = this.keyEntryPanel.getTextField();
        keyBindingLabel.setLabelFor(tf);
        GLabel mouseBindingLabel = new GLabel("Mouse Binding: ");
        mouseBindingLabel.setLabelFor(mouseBindingLabel);
        this.add(keyBindingLabel);
        this.add(this.keyEntryPanel);
        this.add(Box.createHorizontalStrut(30));
        this.add(mouseBindingLabel);
        this.add(this.mouseEntryField);
        this.add(Box.createHorizontalStrut(2));
        this.add(clearMouseButton);
    }

    public void setKeyBindingData(KeyStroke ks, MouseBinding mb) {
        this.keyEntryPanel.setKeyStroke(ks);
        this.mouseEntryField.setMouseBinding(mb);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.keyEntryPanel.clearField();
        this.mouseEntryField.clearField();
        this.keyEntryPanel.setEnabled(enabled);
        this.mouseEntryField.setEnabled(enabled);
    }

    public void clearKeyStroke() {
        this.keyEntryPanel.clearField();
    }

    public KeyStroke getKeyStroke() {
        return this.keyEntryPanel.getKeyStroke();
    }

    public MouseBinding getMouseBinding() {
        return this.mouseEntryField.getMouseBinding();
    }

    public void clearMouseBinding() {
        this.mouseEntryField.clearMouseBinding();
    }
}

