/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.store.FileSystem;
import ghidra.util.InvalidNameException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GhidraURLWrappedContent {
    private final GhidraURLConnection c;
    private List<Object> consumers = new ArrayList<Object>();
    private DefaultProjectData projectData;
    private Object refObject;

    public GhidraURLWrappedContent(GhidraURLConnection c) {
        this.c = c;
    }

    private boolean containsConsumer(Object consumer) {
        for (Object obj : this.consumers) {
            if (obj != consumer) continue;
            return true;
        }
        return false;
    }

    private void addConsumer(Object consumer) {
        if (this.containsConsumer(consumer)) {
            throw new RuntimeException("duplcate consumer");
        }
        this.consumers.add(consumer);
    }

    private void removeConsumer(Object consumer) {
        int cnt = this.consumers.size();
        for (int i = 0; i < cnt; ++i) {
            if (this.consumers.get(i) != consumer) continue;
            this.consumers.remove(i);
            if (this.consumers.isEmpty()) {
                this.closeProjectData();
            }
            return;
        }
        throw new RuntimeException("consumer not found");
    }

    private void closeProjectData() {
        if (this.projectData != null) {
            this.projectData.close();
        }
        this.projectData = null;
        this.refObject = null;
    }

    private DomainFolder getExplicitFolder(String folderPath) throws InvalidNameException, IOException {
        DomainFolder folder = this.projectData.getRootFolder();
        for (String name : folderPath.substring(1).split("/")) {
            DomainFolder subfolder = folder.getFolder(name);
            if (subfolder == null) {
                subfolder = folder.createFolder(name);
            }
            folder = subfolder;
        }
        return folder;
    }

    private void resolve() throws IOException, FileNotFoundException {
        if (this.projectData != null) {
            return;
        }
        this.projectData = (DefaultProjectData)this.c.getProjectData();
        String folderItemName = this.c.getFolderItemName();
        String folderPath = this.c.getFolderPath();
        DomainFolder folder = this.projectData.getFolder(folderPath);
        if (folder == null && folderItemName == null && !this.c.isReadOnly()) {
            try {
                folder = this.getExplicitFolder(folderPath);
            }
            catch (InvalidNameException e) {
                this.closeProjectData();
                throw new IOException("URL specifies invalid path: " + folderPath);
            }
        }
        if (folder == null) {
            this.closeProjectData();
            throw new FileNotFoundException("URL specifies unknown folder path: " + folderPath);
        }
        if (folderItemName == null) {
            this.refObject = folder;
            return;
        }
        DomainFile df = folder.getFile(folderItemName);
        if (df != null) {
            this.refObject = df;
            return;
        }
        DomainFolder subfolder = folder.getFolder(folderItemName);
        if (subfolder != null) {
            this.refObject = subfolder;
            return;
        }
        this.closeProjectData();
        Object path = folderPath;
        if (!((String)path).endsWith(FileSystem.SEPARATOR)) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + folderItemName;
        throw new FileNotFoundException("URL specifies unknown path: " + (String)path);
    }

    public synchronized Object getContent(Object consumer) throws IOException, FileNotFoundException {
        this.addConsumer(consumer);
        boolean success = false;
        try {
            this.resolve();
            success = true;
        }
        finally {
            if (!success || this.refObject == null) {
                this.removeConsumer(consumer);
            }
        }
        return this.refObject;
    }

    public synchronized void release(Object content, Object consumer) {
        if (content == null || content != this.refObject) {
            throw new RuntimeException("Invalid content object specified");
        }
        this.removeConsumer(consumer);
    }
}

