/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation.data;

import ghidra.app.plugin.core.debug.service.emulation.data.DefaultPcodeDebuggerPropertyAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.InternalPcodeDebuggerDataAccess;
import ghidra.app.plugin.core.debug.utils.AbstractMappedMemoryBytesVisitor;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.emulation.PcodeDebuggerMemoryAccess;
import ghidra.debug.api.target.Target;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceMemoryAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DefaultPcodeDebuggerMemoryAccess
extends DefaultPcodeTraceMemoryAccess
implements PcodeDebuggerMemoryAccess,
InternalPcodeDebuggerDataAccess {
    protected final ServiceProvider provider;
    protected final Target target;

    protected DefaultPcodeDebuggerMemoryAccess(ServiceProvider provider, Target target, TracePlatform platform, long snap, TraceTimeViewport viewport) {
        super(platform, snap, viewport);
        this.provider = Objects.requireNonNull(provider);
        this.target = target;
    }

    @Override
    public boolean isLive() {
        return InternalPcodeDebuggerDataAccess.super.isLive();
    }

    @Override
    public ServiceProvider getServiceProvider() {
        return this.provider;
    }

    @Override
    public Target getTarget() {
        return this.target;
    }

    public CompletableFuture<Boolean> readFromTargetMemory(AddressSetView guestView) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        AddressSetView hostView = this.platform.mapGuestToHost(guestView);
        return this.target.readMemoryAsync(hostView, TaskMonitor.DUMMY).thenApply(__ -> true);
    }

    public CompletableFuture<Boolean> writeTargetMemory(Address address, byte[] data) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.target.writeMemoryAsync(address, data).thenApply(__ -> true);
    }

    public AddressSetView readFromStaticImages(final PcodeExecutorStatePiece<byte[], byte[]> piece, AddressSetView guestView) {
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.provider.getService(DebuggerStaticMappingService.class);
        if (mappingService == null) {
            return guestView;
        }
        final AddressSet remains = new AddressSet(guestView);
        try {
            boolean result = new AbstractMappedMemoryBytesVisitor(mappingService, new byte[4096]){

                @Override
                protected int read(Memory memory, Address addr, byte[] dest, int size) throws MemoryAccessException {
                    int read = super.read(memory, addr, dest, size);
                    if (read < size) {
                        Msg.warn((Object)this, (Object)String.format("  Partial read of %s. Wanted %d bytes. Got %d.", addr, size, read));
                    }
                    return read;
                }

                @Override
                protected boolean visitRange(Program program, AddressRange progRng, DebuggerStaticMappingService.MappedAddressRange mappedRng) throws MemoryAccessException {
                    Msg.debug((Object)this, (Object)("Filling in unknown trace memory in emulator using mapped image: " + String.valueOf(program) + ": " + String.valueOf(progRng)));
                    return super.visitRange(program, progRng, mappedRng);
                }

                @Override
                protected void visitData(Address hostAddr, byte[] data, int size) {
                    Address guestAddr = DefaultPcodeDebuggerMemoryAccess.this.platform.mapHostToGuest(hostAddr);
                    piece.setVarInternal(guestAddr.getAddressSpace(), guestAddr.getOffset(), size, (Object)data);
                    remains.delete(guestAddr, guestAddr.add((long)size));
                }
            }.visit(this.platform.getTrace(), this.snap, this.platform.mapGuestToHost(guestView));
            return result ? remains : guestView;
        }
        catch (MemoryAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> PcodeTracePropertyAccess<T> getPropertyAccess(String name, Class<T> type) {
        return new DefaultPcodeDebuggerPropertyAccess<T>(this, name, type);
    }
}

