/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import docking.ComponentProvider;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.debug.gui.model.AbstractObjectsTableBasedPanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackProvider;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;

public class DebuggerStackPanel
extends AbstractObjectsTableBasedPanel<TraceStackFrame>
implements ListSelectionListener {
    private final DebuggerStackProvider provider;
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;

    static Address computeProgramCounter(ObjectTableModel.ValueRow row, long snap) {
        Object object;
        Object object2 = row.getValue().getValue();
        if (!(object2 instanceof TraceObject)) {
            return null;
        }
        TraceObject object3 = (TraceObject)object2;
        TraceObjectValue attrPc = object3.getAttribute(snap, "_pc");
        if (attrPc == null || !((object = attrPc.getValue()) instanceof Address)) {
            return null;
        }
        Address pc = (Address)object;
        return pc;
    }

    private Function computeFunction(ObjectTableModel.ValueRow row, long snap, ServiceProvider serviceProvider) {
        Address pc = DebuggerStackPanel.computeProgramCounter(row, snap);
        if (pc == null) {
            return null;
        }
        return DebuggerStaticMappingUtils.getFunction(pc, this.provider.current, serviceProvider);
    }

    private String computeModuleName(ObjectTableModel.ValueRow row, long snap) {
        Address pc = DebuggerStackPanel.computeProgramCounter(row, snap);
        if (pc == null) {
            return null;
        }
        return DebuggerStaticMappingUtils.getModuleName(pc, this.provider.current);
    }

    public DebuggerStackPanel(DebuggerStackProvider provider) {
        super(provider.plugin, (ComponentProvider)provider, TraceStackFrame.class);
        this.provider = provider;
    }

    @Override
    protected ObjectTableModel createModel() {
        return new StackTableModel(this.plugin);
    }

    @Override
    protected ModelQuery computeQuery(TraceObject object) {
        TraceObjectSchema rootSchema = object.getRoot().getSchema();
        KeyPath stackPath = rootSchema.searchForSuitable(TraceStack.class, object.getCanonicalPath());
        if (stackPath == null) {
            return ModelQuery.EMPTY;
        }
        TraceObjectSchema stackSchema = rootSchema.getSuccessorSchema(stackPath);
        PathFilter filter = stackSchema.searchFor(TraceStackFrame.class, stackPath, true);
        return new ModelQuery(filter);
    }

    @Override
    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        super.coordinatesActivated(coordinates);
        TraceObject object = coordinates.getObject();
        if (object != null) {
            this.trySelectAncestor(object);
        }
    }

    @Override
    public void cellActivated(JTable table) {
        ObjectTableModel.ValueRow item = (ObjectTableModel.ValueRow)this.getSelectedItem();
        if (item != null) {
            this.traceManager.activateObject(item.getValue().getChild());
        }
    }

    private class StackTableModel
    extends ObjectTableModel {
        protected StackTableModel(Plugin plugin) {
            super(plugin);
        }

        @Override
        protected TableColumnDescriptor<ObjectTableModel.ValueRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn((DynamicTableColumn)new FrameLevelColumn(), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new FramePcColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new FrameFunctionColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new FrameModuleColumn());
            return descriptor;
        }
    }

    private class FrameModuleColumn
    extends TraceValueObjectPropertyColumn<String> {
        public FrameModuleColumn() {
            super(String.class);
        }

        @Override
        public ObjectTableModel.ValueProperty<String> getProperty(ObjectTableModel.ValueRow row) {
            return new ObjectTableModel.ValueDerivedProperty<String>(row, String.class){

                @Override
                public String getValue() {
                    return DebuggerStackPanel.this.computeModuleName(this.row, this.row.currentSnap());
                }

                @Override
                public boolean isModified() {
                    return !Objects.equals(DebuggerStackPanel.this.computeModuleName(this.row, this.row.currentSnap()), DebuggerStackPanel.this.computeModuleName(this.row, this.row.previousSnap()));
                }
            };
        }

        public String getColumnName() {
            return "Module";
        }
    }

    private class FrameFunctionColumn
    extends TraceValueObjectPropertyColumn<Function> {
        public FrameFunctionColumn() {
            super(Function.class);
        }

        @Override
        public ObjectTableModel.ValueProperty<Function> getProperty(ObjectTableModel.ValueRow row) {
            throw new AssertionError();
        }

        @Override
        public ObjectTableModel.ValueProperty<Function> getValue(ObjectTableModel.ValueRow row, Settings settings, Trace data, final ServiceProvider serviceProvider) throws IllegalArgumentException {
            return new ObjectTableModel.ValueDerivedProperty<Function>(row, Function.class){

                @Override
                public Function getValue() {
                    return DebuggerStackPanel.this.computeFunction(this.row, this.row.currentSnap(), serviceProvider);
                }

                @Override
                public boolean isModified() {
                    return !Objects.equals(DebuggerStackPanel.this.computeFunction(this.row, this.row.currentSnap(), serviceProvider), DebuggerStackPanel.this.computeFunction(this.row, this.row.previousSnap(), serviceProvider));
                }
            };
        }

        public String getColumnName() {
            return "Function";
        }
    }

    private static class FramePcColumn
    extends TraceValueObjectAttributeColumn<Address> {
        public FramePcColumn() {
            super("_pc", Address.class);
        }

        @Override
        public String getColumnName() {
            return "PC";
        }
    }

    private static class FrameLevelColumn
    extends TraceValueKeyColumn {
        private FrameLevelColumn() {
        }

        @Override
        public String getColumnName() {
            return "Level";
        }

        public int getColumnPreferredWidth() {
            return 60;
        }
    }
}

