/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ArtHeader
implements StructConverter {
    protected String magic_;
    protected String version_;
    protected List<Long> imageMethodsList = new ArrayList<Long>();

    protected ArtHeader(BinaryReader reader) throws IOException {
        this.magic_ = new String(reader.readNextByteArray("art\n".length()));
        this.version_ = reader.readNextAsciiString(4);
    }

    public final String getMagic() {
        return this.magic_;
    }

    public final String getVersion() {
        return this.version_;
    }

    public abstract int getImageBegin();

    public abstract int getImageSize();

    public abstract int getOatChecksum();

    public abstract int getOatFileBegin();

    public abstract int getOatFileEnd();

    public abstract int getOatDataBegin();

    public abstract int getOatDataEnd();

    public abstract int getPointerSize();

    public abstract int getArtMethodCountForVersion();

    protected abstract void parse(BinaryReader var1) throws IOException;

    protected final void parseImageMethods(BinaryReader reader) throws IOException {
        for (int i = 0; i < this.getArtMethodCountForVersion(); ++i) {
            this.imageMethodsList.add(reader.readNextLong());
        }
    }

    public abstract void markup(Program var1, TaskMonitor var2) throws Exception;

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(ArtHeader.class.getSimpleName() + "_" + this.version_, 0);
        structure.add(STRING, 4, "magic_", null);
        structure.add(STRING, 4, "version_", null);
        structure.setCategoryPath(new CategoryPath("/art"));
        return structure;
    }
}

