/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.IllegalFieldAccessException;
import db.PrimitiveField;
import db.buffers.DataBuffer;
import java.io.IOException;

public final class ShortField
extends PrimitiveField {
    public static final ShortField MIN_VALUE = new ShortField(Short.MIN_VALUE, true);
    public static final ShortField MAX_VALUE = new ShortField(Short.MAX_VALUE, true);
    public static final ShortField ZERO_VALUE;
    public static final ShortField INSTANCE;
    private short value;

    public ShortField() {
    }

    public ShortField(short s) {
        this(s, false);
    }

    ShortField(short s, boolean immutable) {
        super(immutable);
        this.value = s;
    }

    @Override
    void setNull() {
        super.setNull();
        this.value = 0;
    }

    @Override
    public short getShortValue() {
        return this.value;
    }

    @Override
    public void setShortValue(short value) {
        this.updatingPrimitiveValue();
        this.value = value;
    }

    @Override
    int length() {
        return 2;
    }

    @Override
    int write(Buffer buf, int offset) throws IndexOutOfBoundsException, IOException {
        return buf.putShort(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IndexOutOfBoundsException, IOException {
        this.updatingPrimitiveValue();
        this.value = buf.getShort(offset);
        return offset + 2;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 2;
    }

    @Override
    byte getFieldType() {
        return 1;
    }

    @Override
    public String getValueAsString() {
        return "0x" + Integer.toHexString(this.value & 0xFFFF);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ShortField)) {
            return false;
        }
        return ((ShortField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        ShortField f = (ShortField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        short otherValue = buffer.getShort(offset);
        if (this.value == otherValue) {
            return 0;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 1;
    }

    @Override
    public ShortField copyField() {
        if (this.isNull()) {
            ShortField copy = new ShortField();
            copy.setNull();
            return copy;
        }
        return new ShortField((short)this.getLongValue());
    }

    @Override
    public ShortField newField() {
        return new ShortField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.setShortValue((short)value);
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{(byte)(this.value >> 8), (byte)this.value};
    }

    @Override
    public void setBinaryData(byte[] bytes) {
        if (bytes == null) {
            this.setNull();
            return;
        }
        if (bytes.length != 2) {
            throw new IllegalFieldAccessException();
        }
        this.updatingPrimitiveValue();
        this.value = (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    ShortField getMinValue() {
        return MIN_VALUE;
    }

    @Override
    ShortField getMaxValue() {
        return MAX_VALUE;
    }

    static {
        INSTANCE = ZERO_VALUE = new ShortField(0, true);
    }
}

