/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.GhidraDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class Pic24DInitAnalyzer
extends AbstractAnalyzer {
    private static final int DST_ORDINAL = 0;
    private static final int LEN_ORDINAL = 1;
    private static final int FORMAT_ORDINAL = 2;
    private static final int PAGE_ORDINAL = 3;

    public Pic24DInitAnalyzer() {
        super("DInit Analyzer", "Processes .dinit Data Initialization Section", AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS.before());
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        boolean isSupportedProcessor;
        String processorName = program.getLanguage().getProcessor().toString();
        boolean bl = isSupportedProcessor = processorName.contentEquals("PIC-24") || processorName.startsWith("dsPIC3");
        if (!isSupportedProcessor) {
            return false;
        }
        if (!"Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            return false;
        }
        return program.getMemory().getBlock(".dinit") != null;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Listing listing = program.getListing();
        ReferenceManager referenceManager = program.getReferenceManager();
        MemoryBlock dinitBlock = program.getMemory().getBlock(".dinit");
        if (listing.getDefinedDataContaining(dinitBlock.getStart()) != null) {
            Msg.info((Object)((Object)this), (Object)("Skipping .dinit processing due to existing data at " + String.valueOf(dinitBlock.getStart())));
            return true;
        }
        MemoryBufferImpl memBuffer = new MemoryBufferImpl(program.getMemory(), dinitBlock.getStart());
        long available = dinitBlock.getSize();
        StructureDataType dataRecordType = new StructureDataType("data_record", 0, (DataTypeManager)program.getDataTypeManager());
        dataRecordType.setPackingEnabled(true);
        dataRecordType.add((DataType)PointerDataType.dataType, "dst", null);
        dataRecordType.add((DataType)LongDataType.dataType, "len", null);
        try {
            dataRecordType.addBitField((DataType)LongDataType.dataType, 7, "format", null);
            dataRecordType.addBitField((DataType)LongDataType.dataType, 9, "page", null);
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        dataRecordType.add((DataType)new ArrayDataType((DataType)ByteDataType.dataType, 0, -1), "data", null);
        dataRecordType = (Structure)program.getDataTypeManager().resolve((DataType)dataRecordType, null);
        GhidraDataConverter converter = GhidraDataConverter.getInstance((boolean)false);
        AddressSpace dataSpace = program.getLanguage().getDefaultDataSpace();
        try {
            short dst;
            Address addr = dinitBlock.getStart();
            int offset = 0;
            while ((long)offset < available && (dst = converter.getShort((MemBuffer)memBuffer, offset)) != 0) {
                Data dataRecord = listing.createData(addr, (DataType)dataRecordType);
                Scalar len = (Scalar)dataRecord.getComponent(1).getValue();
                Scalar format = (Scalar)dataRecord.getComponent(2).getValue();
                Scalar page = (Scalar)dataRecord.getComponent(3).getValue();
                Reference ref = referenceManager.getPrimaryReferenceFrom(addr, 0);
                if (ref != null) {
                    referenceManager.delete(ref);
                }
                Address dstAddr = dataSpace.getAddress((long)(dst & 0xFFFF));
                referenceManager.addMemoryReference(addr, dstAddr, RefType.DATA, SourceType.ANALYSIS, 0);
                offset += dataRecordType.getLength();
                addr = addr.add((long)dataRecord.getLength());
                Data arrayData = null;
                long fmt = format.getValue();
                if (fmt == 0L) continue;
                int flexArrayLen = 0;
                if (fmt == 1L) {
                    flexArrayLen = (int)(4L * ((len.getValue() + 1L) / 2L));
                } else {
                    if (fmt != 2L) {
                        Msg.error((Object)((Object)this), (Object)("Invalid .dinit format value at " + String.valueOf(dataRecord.getComponent(2).getAddress())));
                        break;
                    }
                    flexArrayLen = (int)(4L * ((len.getValue() + 2L) / 3L));
                }
                if (flexArrayLen < 0 || (long)(offset + flexArrayLen) > available) {
                    Msg.error((Object)((Object)this), (Object)("Invalid .dinit len value at " + String.valueOf(dataRecord.getComponent(1).getAddress())));
                    break;
                }
                ArrayDataType flexArray = new ArrayDataType((DataType)ByteDataType.dataType, flexArrayLen, 1);
                arrayData = listing.createData(addr, (DataType)flexArray);
                offset += flexArrayLen;
                addr = addr.add((long)flexArrayLen);
            }
        }
        catch (MemoryAccessException | CodeUnitInsertionException e) {
            Msg.error((Object)((Object)this), (Object)("Failed during .dinit processing: " + e.getMessage()));
        }
        return true;
    }
}

