/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemoryBlock;
import ghidra.trace.database.program.DBTraceProgramView;

public class DBTraceProgramViewMemorySpaceBlock
extends AbstractDBTraceProgramViewMemoryBlock {
    private final AddressSpace space;

    public DBTraceProgramViewMemorySpaceBlock(DBTraceProgramView program, AddressSpace space) {
        super(program);
        this.space = space;
    }

    @Override
    protected String getInfoDescription() {
        return "Trace space: " + String.valueOf(this.space);
    }

    @Override
    protected AddressSpace getAddressSpace() {
        return this.space;
    }

    public Address getStart() {
        return this.space.getMinAddress();
    }

    public Address getEnd() {
        return this.space.getMaxAddress();
    }

    public int getFlags() {
        return 7;
    }

    public String getName() {
        return this.space.getName();
    }

    public void setName(String name) throws IllegalArgumentException, LockException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String comment) {
        throw new UnsupportedOperationException();
    }

    public boolean isRead() {
        return true;
    }

    public void setRead(boolean r) {
        throw new UnsupportedOperationException();
    }

    public boolean isWrite() {
        return true;
    }

    public void setWrite(boolean w) {
        throw new UnsupportedOperationException();
    }

    public boolean isExecute() {
        return true;
    }

    public void setExecute(boolean e) {
        throw new UnsupportedOperationException();
    }

    public void setPermissions(boolean read, boolean write, boolean execute) {
        throw new UnsupportedOperationException();
    }

    public boolean isVolatile() {
        return false;
    }

    public void setVolatile(boolean v) {
        throw new UnsupportedOperationException();
    }

    public boolean isArtificial() {
        return false;
    }

    public void setArtificial(boolean a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourceName() {
        return "Trace";
    }

    @Override
    public void setSourceName(String sourceName) {
        throw new UnsupportedOperationException();
    }
}

