/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.memory.DBTraceEmptyMemBuffer;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.memory.InternalTraceMemoryOperations;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.MathUtilities;
import ghidra.util.UnionAddressSetView;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;

public class DBTraceMemoryManager
extends AbstractDBTraceSpaceBasedManager<DBTraceMemorySpace>
implements TraceMemoryManager,
InternalTraceMemoryOperations,
DBTraceDelegatingManager<DBTraceMemorySpace> {
    protected static final String NAME = "Memory";
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;

    public DBTraceMemoryManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws IOException, VersionException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.overlayAdapter = overlayAdapter;
        this.loadSpaces();
    }

    @Override
    public AddressSpace getSpace() {
        return null;
    }

    @Override
    public AddressSpace createOverlayAddressSpace(String name, AddressSpace base) throws DuplicateNameException {
        return this.overlayAdapter.createOverlayAddressSpace(name, base);
    }

    @Override
    public AddressSpace getOrCreateOverlayAddressSpace(String name, AddressSpace base) {
        return this.overlayAdapter.getOrCreateOverlayAddressSpace(name, base);
    }

    @Override
    public void deleteOverlayAddressSpace(String name) {
        this.overlayAdapter.deleteOverlayAddressSpace(name);
    }

    @Override
    protected DBTraceMemorySpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceMemorySpace(this, this.dbh, space, ent);
    }

    @Override
    public DBTraceMemorySpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceMemorySpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public DBTraceMemorySpace getMemorySpace(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceMemorySpace getMemoryRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceMemorySpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    @Override
    public DBTraceMemorySpace getMemoryRegisterSpace(TraceThread thread, int frame, boolean createIfAbsent) {
        return (DBTraceMemorySpace)this.getForRegisterSpace(thread, frame, createIfAbsent);
    }

    @Override
    public DBTraceMemorySpace getMemoryRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return (DBTraceMemorySpace)this.getForRegisterSpace(frame, createIfAbsent);
    }

    @Override
    public TraceMemoryRegion addRegion(String path, Lifespan lifespan, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException {
        return this.trace.getObjectManager().addMemoryRegion(path, lifespan, range, flags);
    }

    @Override
    public Collection<? extends TraceMemoryRegion> getAllRegions() {
        return this.trace.getObjectManager().getAllObjects(TraceMemoryRegion.class);
    }

    @Override
    public TraceMemoryRegion getLiveRegionByPath(long snap, String path) {
        return this.trace.getObjectManager().getObjectByPath(snap, path, TraceMemoryRegion.class);
    }

    @Override
    public TraceMemoryRegion getRegionContaining(long snap, Address address) {
        return this.trace.getObjectManager().getObjectContaining(snap, address, "_range", TraceMemoryRegion.class);
    }

    @Override
    public Collection<? extends TraceMemoryRegion> getRegionsIntersecting(Lifespan lifespan, AddressRange range) {
        return this.trace.getObjectManager().getObjectsIntersecting(lifespan, range, "_range", TraceMemoryRegion.class);
    }

    @Override
    public Collection<? extends TraceMemoryRegion> getRegionsAtSnap(long snap) {
        return this.trace.getObjectManager().getObjectsAtSnap(snap, TraceMemoryRegion.class);
    }

    @Override
    public AddressSetView getRegionsAddressSet(long snap) {
        return this.trace.getObjectManager().getObjectsAddressSet(snap, "_range", TraceMemoryRegion.class, r -> true);
    }

    @Override
    public AddressSetView getRegionsAddressSetWith(long snap, Predicate<TraceMemoryRegion> predicate) {
        return this.trace.getObjectManager().getObjectsAddressSet(snap, "_range", TraceMemoryRegion.class, predicate);
    }

    @Override
    public void setState(long snap, Address address, TraceMemoryState state) {
        this.delegateWriteV(address.getAddressSpace(), m -> m.setState(snap, address, state));
    }

    @Override
    public void setState(long snap, Address start, Address end, TraceMemoryState state) {
        this.delegateWriteV(start.getAddressSpace(), m -> m.setState(snap, start, end, state));
    }

    @Override
    public void setState(long snap, AddressRange range, TraceMemoryState state) {
        this.delegateWriteV(range.getAddressSpace(), m -> m.setState(snap, range, state));
    }

    @Override
    public void setState(long snap, AddressSetView set, TraceMemoryState state) {
        for (AddressRange range : set) {
            this.delegateWriteV(range.getAddressSpace(), m -> m.setState(snap, range, state));
        }
    }

    @Override
    public TraceMemoryState getState(long snap, Address address) {
        return (TraceMemoryState)((Object)this.delegateRead(address.getAddressSpace(), m -> m.getState(snap, address)));
    }

    @Override
    public Map.Entry<Long, TraceMemoryState> getViewState(long snap, Address address) {
        return (Map.Entry)this.delegateReadOr(address.getAddressSpace(), m -> m.getViewState(snap, address), () -> Map.entry(snap, TraceMemoryState.UNKNOWN));
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getMostRecentStateEntry(long snap, Address address) {
        return (Map.Entry)this.delegateRead(address.getAddressSpace(), m -> m.getMostRecentStateEntry(snap, address));
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getViewMostRecentStateEntry(long snap, AddressRange range, Predicate<TraceMemoryState> predicate) {
        return (Map.Entry)this.delegateRead(range.getAddressSpace(), m -> m.getViewMostRecentStateEntry(snap, range, predicate));
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getViewMostRecentStateEntry(long snap, Address address) {
        return (Map.Entry)this.delegateRead(address.getAddressSpace(), m -> m.getViewMostRecentStateEntry(snap, address));
    }

    @Override
    public AddressSetView getAddressesWithState(Lifespan snap, AddressSetView set, Predicate<TraceMemoryState> predicate) {
        return this.delegateAddressSet(this.getActiveSpaces(), m -> m.getAddressesWithState(snap, set, predicate));
    }

    @Override
    public AddressSetView getAddressesWithState(long snap, Predicate<TraceMemoryState> predicate) {
        return new UnionAddressSetView(this.getActiveSpaces().stream().map(m -> m.getAddressesWithState(snap, predicate)).toList());
    }

    @Override
    public AddressSetView getAddressesWithState(Lifespan lifespan, Predicate<TraceMemoryState> predicate) {
        return new UnionAddressSetView(this.getActiveSpaces().stream().map(m -> m.getAddressesWithState(lifespan, predicate)).toList());
    }

    protected Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> doGetStates(Lifespan span, AddressRange range) {
        return (Collection)this.delegateReadOr(range.getAddressSpace(), m -> m.doGetStates(span, range), () -> List.of(Map.entry(new ImmutableTraceAddressSnapRange(range, span), TraceMemoryState.UNKNOWN)));
    }

    @Override
    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(long snap, AddressRange range) {
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getStates(snap, range), Collections.emptyList());
    }

    @Override
    public Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getMostRecentStates(TraceAddressSnapRange within) {
        return (Iterable)this.delegateRead(within.getRange().getAddressSpace(), m -> m.getMostRecentStates(within), Collections.emptyList());
    }

    @Override
    public int putBytes(long snap, Address start, ByteBuffer buf) {
        return this.delegateWriteI(start.getAddressSpace(), m -> m.putBytes(snap, start, buf));
    }

    @Override
    public int getBytes(long snap, Address start, ByteBuffer buf) {
        return this.delegateReadI(start.getAddressSpace(), m -> m.getBytes(snap, start, buf), () -> {
            Address max = start.getAddressSpace().getMaxAddress();
            int len = MathUtilities.unsignedMin((int)buf.remaining(), (long)max.subtract(start));
            buf.position(buf.position() + len);
            return len;
        });
    }

    @Override
    public int getViewBytes(long snap, Address start, ByteBuffer buf) {
        return this.delegateReadI(start.getAddressSpace(), m -> m.getViewBytes(snap, start, buf), () -> {
            Address max = start.getAddressSpace().getMaxAddress();
            int len = MathUtilities.unsignedMin((int)buf.remaining(), (long)max.subtract(start));
            buf.position(buf.position() + len);
            return len;
        });
    }

    @Override
    public void removeBytes(long snap, Address start, int len) {
        this.delegateDeleteV(start.getAddressSpace(), m -> m.removeBytes(snap, start, len));
    }

    @Override
    public Address findBytes(long snap, AddressRange range, ByteBuffer data, ByteBuffer mask, boolean forward, TaskMonitor monitor) {
        return (Address)this.delegateRead(range.getAddressSpace(), m -> m.findBytes(snap, range, data, mask, forward, monitor));
    }

    @Override
    public MemBuffer getBufferAt(long snap, Address start, ByteOrder byteOrder) {
        MemBuffer buffer = (MemBuffer)this.delegateRead(start.getAddressSpace(), m -> m.getBufferAt(snap, start, byteOrder));
        if (buffer == null) {
            return new DBTraceEmptyMemBuffer(this.trace, start, byteOrder);
        }
        return buffer;
    }

    @Override
    public Long getSnapOfMostRecentChangeToBlock(long snap, Address address) {
        return (Long)this.delegateRead(address.getAddressSpace(), m -> m.getSnapOfMostRecentChangeToBlock(snap, address));
    }

    @Override
    public int getBlockSize() {
        return 4096;
    }

    @Override
    public void pack() {
        this.delegateWriteAll(this.getActiveSpaces(), m -> m.pack());
    }

    @Override
    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStateChanges(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        Lifespan between = from < to ? Lifespan.span(from + 1L, to) : Lifespan.span(to + 1L, from);
        ArrayList<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> result = new ArrayList<Map.Entry<TraceAddressSnapRange, TraceMemoryState>>();
        for (DBTraceMemorySpace space : this.spaces.values()) {
            AddressRangeImpl rng = new AddressRangeImpl(space.space.getMinAddress(), space.space.getMaxAddress());
            result.addAll(space.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.enclosed((AddressRange)rng, between)).entries());
        }
        return result;
    }
}

