/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TraceGuestPlatformMappedRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.guest.TracePlatformManager;
import ghidra.trace.model.memory.RegisterValueConverter;
import ghidra.trace.model.memory.RegisterValueException;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceRegister;
import ghidra.trace.model.memory.TraceRegisterContainer;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbolView;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Stream;

public final class DBTraceObjectRegisterSupport
extends Enum<DBTraceObjectRegisterSupport> {
    public static final /* enum */ DBTraceObjectRegisterSupport INSTANCE = new DBTraceObjectRegisterSupport();
    private static final TraceDomainObjectListener HANDLER;
    private static final /* synthetic */ DBTraceObjectRegisterSupport[] $VALUES;

    public static DBTraceObjectRegisterSupport[] values() {
        return (DBTraceObjectRegisterSupport[])$VALUES.clone();
    }

    public static DBTraceObjectRegisterSupport valueOf(String name) {
        return Enum.valueOf(DBTraceObjectRegisterSupport.class, name);
    }

    protected AddressSpace findRegisterOverlay(TraceObject object) {
        TraceObject container = object.findCanonicalAncestorsInterface(TraceRegisterContainer.class).findFirst().orElse(null);
        if (container == null) {
            return null;
        }
        String pathStr = container.getCanonicalPath().toString();
        Trace trace = object.getTrace();
        return trace.getMemoryManager().getOrCreateOverlayAddressSpace(pathStr, trace.getBaseAddressFactory().getRegisterSpace());
    }

    protected AddressSpace findRegisterOverlay(TraceObjectValue objectValue) {
        return this.findRegisterOverlay(objectValue.getParent());
    }

    protected void onValueCreatedTransferToPlatformRegister(TraceObjectValue registerValue, TracePlatform platform, String name, RegisterValueConverter rvc) throws RegisterValueException {
        Register register = platform.getLanguage().getRegister(name);
        if (register == null) {
            return;
        }
        Address hostAddr = platform.mapGuestToHost(register.getAddress());
        if (hostAddr == null) {
            return;
        }
        AddressSpace hostSpace = hostAddr.getAddressSpace();
        TraceMemoryManager mem = registerValue.getTrace().getMemoryManager();
        long minSnap = registerValue.getMinSnap();
        if (hostSpace.isMemorySpace()) {
            mem.getMemorySpace(hostSpace, true).setValue(platform, minSnap, new RegisterValue(register, rvc.getValue()));
        } else if (hostSpace.isRegisterSpace()) {
            AddressSpace overlay = this.findRegisterOverlay(registerValue);
            if (overlay == null) {
                return;
            }
            mem.getMemorySpace(overlay, true).setValue(platform, minSnap, new RegisterValue(register, rvc.getValue()));
        } else {
            throw new AssertionError();
        }
    }

    protected void transferValueToPlatformRegister(TraceObjectValue registerValue, TracePlatform platform, TraceMemorySpace mem, Register register) {
        RegisterValueConverter rvc = new RegisterValueConverter(registerValue);
        try {
            mem.setValue(platform, registerValue.getMinSnap(), new RegisterValue(register, rvc.getValue()));
        }
        catch (RegisterValueException e) {
            Msg.error((Object)((Object)this), (Object)e.getMessage());
        }
    }

    protected String getRegisterName(TraceObject registerObject) {
        return KeyPath.parseIfIndex(registerObject.getCanonicalPath().key());
    }

    protected void onSpaceAddedCheckTransferObjectToPlatformRegister(TraceObject registerObject, TracePlatform platform, TraceMemorySpace mem) {
        String name = this.getRegisterName(registerObject);
        Register register = platform.getLanguage().getRegister(name);
        if (register == null || !register.getAddressSpace().isRegisterSpace()) {
            return;
        }
        for (TraceObjectValue traceObjectValue : DBTraceObjectRegisterSupport.it(registerObject.getOrderedValues(Lifespan.ALL, "_value", true))) {
            this.transferValueToPlatformRegister(traceObjectValue, platform, mem, register);
        }
    }

    protected void onSpaceAddedCheckTransferToPlatformRegisters(TracePlatform platform, TraceObject regContainer, TraceMemorySpace mem) {
        for (TraceObjectValPath traceObjectValPath : DBTraceObjectRegisterSupport.it(regContainer.findSuccessorsInterface(Lifespan.ALL, TraceRegister.class, true))) {
            TraceObject registerObject = traceObjectValPath.getDestination(platform.getTrace().getObjectManager().getRootObject());
            this.onSpaceAddedCheckTransferObjectToPlatformRegister(registerObject, platform, mem);
        }
    }

    protected TraceMemorySpace getMemorySpace(TraceObject object, TraceLabelSymbol label) {
        Address hostAddr = label.getAddress();
        AddressSpace hostSpace = hostAddr.getAddressSpace();
        TraceMemoryManager mem = label.getTrace().getMemoryManager();
        if (hostSpace.isMemorySpace()) {
            return mem.getMemorySpace(hostSpace, true);
        }
        if (hostSpace.isRegisterSpace()) {
            AddressSpace overlay = this.findRegisterOverlay(object);
            return mem.getMemorySpace(overlay, true);
        }
        throw new AssertionError();
    }

    protected void transferRegisterValueToLabel(TraceObjectValue registerValue, TraceLabelSymbol label, byte[] value) {
        TraceMemorySpace mem = this.getMemorySpace(registerValue.getParent(), label);
        Address hostAddr = label.getAddress();
        long minSnap = registerValue.getMinSnap();
        Address address = mem.getAddressSpace().getOverlayAddress(hostAddr);
        mem.putBytes(minSnap, address, ByteBuffer.wrap(value));
    }

    protected static <T> Iterable<T> it(Stream<T> stream) {
        return () -> stream.iterator();
    }

    protected void transferRegisterObjectToLabel(TraceObject registerObject, TraceLabelSymbol label, boolean isBigEndian) {
        TraceMemorySpace mem = this.getMemorySpace(registerObject, label);
        Address address = mem.getAddressSpace().getOverlayAddress(label.getAddress());
        for (TraceObjectValue traceObjectValue : DBTraceObjectRegisterSupport.it(registerObject.getOrderedValues(label.getLifespan(), "_value", true))) {
            RegisterValueConverter rvc = new RegisterValueConverter(traceObjectValue);
            try {
                long minSnap = traceObjectValue.getMinSnap();
                mem.putBytes(minSnap, address, ByteBuffer.wrap(rvc.getBytes(isBigEndian)));
            }
            catch (RegisterValueException e) {
                Msg.error((Object)((Object)this), (Object)e.getMessage());
            }
        }
    }

    public void onValueCreatedTransfer(TraceObjectValue registerValue) throws RegisterValueException {
        TraceNamespaceSymbol nsRegMapLE;
        TraceObject registerObject = registerValue.getParent();
        Trace trace = registerValue.getTrace();
        RegisterValueConverter rvc = new RegisterValueConverter(registerValue);
        String name = this.getRegisterName(registerObject);
        TracePlatformManager platformManager = trace.getPlatformManager();
        this.onValueCreatedTransferToPlatformRegister(registerValue, platformManager.getHostPlatform(), name, rvc);
        for (TracePlatform tracePlatform : platformManager.getGuestPlatforms()) {
            this.onValueCreatedTransferToPlatformRegister(registerValue, tracePlatform, name, rvc);
        }
        TraceNamespaceSymbolView namespaces = trace.getSymbolManager().namespaces();
        TraceNamespaceSymbol traceNamespaceSymbol = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_be__");
        if (traceNamespaceSymbol != null) {
            for (TraceLabelSymbol label : trace.getSymbolManager().labels().getChildrenNamed(name, traceNamespaceSymbol)) {
                this.transferRegisterValueToLabel(registerValue, label, rvc.getBytesBigEndian());
            }
        }
        if ((nsRegMapLE = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_le__")) != null) {
            for (TraceLabelSymbol label : trace.getSymbolManager().labels().getChildrenNamed(name, nsRegMapLE)) {
                this.transferRegisterValueToLabel(registerValue, label, rvc.getBytesLittleEndian());
            }
        }
    }

    protected boolean isRegisterValue(TraceObjectValue objectValue) {
        TraceObject parent = objectValue.getParent();
        return parent != null && parent.getSchema().getInterfaces().contains(TraceRegister.class) && "_value".equals(objectValue.getEntryKey());
    }

    public void onValueCreatedCheckTransfer(TraceObjectValue objectValue) {
        if (this.isRegisterValue(objectValue)) {
            try {
                this.onValueCreatedTransfer(objectValue);
            }
            catch (RegisterValueException e) {
                Msg.error((Object)((Object)this), (Object)e.getMessage());
            }
        }
    }

    public void onSymbolAddedCheckTransferToLabel(TraceLabelSymbol label, boolean isBigEndian) {
        TraceObjectManager objectManager = label.getTrace().getObjectManager();
        TraceObjectSchema schema = objectManager.getRootSchema();
        if (schema == null) {
            return;
        }
        PathFilter filter = schema.searchFor(TraceRegister.class, true);
        PathFilter applied = filter.applyKeys(PathFilter.Align.RIGHT, List.of(label.getName()));
        for (TraceObjectValPath traceObjectValPath : DBTraceObjectRegisterSupport.it(objectManager.getValuePaths(label.getLifespan(), applied))) {
            Object regRaw = traceObjectValPath.getDestinationValue(objectManager.getRootObject());
            if (!(regRaw instanceof TraceObject)) continue;
            TraceObject regObj = (TraceObject)regRaw;
            this.transferRegisterObjectToLabel(regObj, label, isBigEndian);
        }
    }

    public void onSymbolAddedCheckTransfer(TraceSymbol symbol) {
        TraceObject root = symbol.getTrace().getObjectManager().getRootObject();
        if (root == null) {
            return;
        }
        if (symbol instanceof TraceLabelSymbol) {
            TraceLabelSymbol label = (TraceLabelSymbol)symbol;
            TraceNamespaceSymbolView namespaces = label.getTrace().getSymbolManager().namespaces();
            TraceNamespaceSymbol regMapBE = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_be__");
            TraceNamespaceSymbol regMapLE = (TraceNamespaceSymbol)namespaces.getGlobalNamed("__reg_map_le__");
            if (label.getParentNamespace() == regMapBE) {
                this.onSymbolAddedCheckTransferToLabel(label, true);
            } else if (label.getParentNamespace() == regMapLE) {
                this.onSymbolAddedCheckTransferToLabel(label, false);
            }
        }
    }

    public void onSpaceAddedCheckTransfer(Trace trace, AddressSpace space) {
        TraceObject root = trace.getObjectManager().getRootObject();
        if (root == null) {
            return;
        }
        assert (space.isOverlaySpace());
        if (!space.isRegisterSpace()) {
            return;
        }
        TraceMemorySpace mem = trace.getMemoryManager().getMemorySpace(space, true);
        TraceObject regContainer = trace.getObjectManager().getObjectByCanonicalPath(KeyPath.parse(mem.getAddressSpace().getName()));
        if (regContainer == null || !regContainer.getSchema().getInterfaces().contains(TraceRegisterContainer.class)) {
            return;
        }
        TracePlatformManager platformManager = trace.getPlatformManager();
        this.onSpaceAddedCheckTransferToPlatformRegisters(platformManager.getHostPlatform(), regContainer, mem);
        for (TraceGuestPlatform platform : platformManager.getGuestPlatforms()) {
            this.onSpaceAddedCheckTransferToPlatformRegisters(platform, regContainer, mem);
        }
    }

    protected void onMappingAddedCheckTransferRegisterObjectMemoryMapped(TraceObject registerObject, TraceGuestPlatformMappedRange mapped) {
        String name = this.getRegisterName(registerObject);
        TraceGuestPlatform guest = mapped.getGuestPlatform();
        Register register = guest.getLanguage().getRegister(name);
        if (register == null || mapped.getGuestRange().contains(register.getAddress())) {
            return;
        }
        Address hostAddr = mapped.mapGuestToHost(register.getAddress());
        if (hostAddr == null) {
            return;
        }
        TraceMemorySpace mem = registerObject.getTrace().getMemoryManager().getMemorySpace(hostAddr.getAddressSpace(), true);
        for (TraceObjectValue traceObjectValue : DBTraceObjectRegisterSupport.it(registerObject.getOrderedValues(Lifespan.ALL, "_value", true))) {
            this.transferValueToPlatformRegister(traceObjectValue, guest, mem, register);
        }
    }

    public void onMappingAddedCheckTransferMemoryMapped(TraceObject root, TraceGuestPlatformMappedRange mapped) {
        for (TraceObjectValPath traceObjectValPath : DBTraceObjectRegisterSupport.it(root.findSuccessorsInterface(Lifespan.ALL, TraceRegister.class, true))) {
            TraceObject registerObject = traceObjectValPath.getDestination(root);
            this.onMappingAddedCheckTransferRegisterObjectMemoryMapped(registerObject, mapped);
        }
    }

    public void onMappingAddedCheckTransfer(TraceGuestPlatformMappedRange mapped) {
        Trace trace = mapped.getHostPlatform().getTrace();
        TraceObject root = trace.getObjectManager().getRootObject();
        if (root == null) {
            return;
        }
        AddressSpace guestSpace = mapped.getGuestRange().getAddressSpace();
        if (guestSpace.isRegisterSpace()) {
            for (AddressSpace space : trace.getBaseAddressFactory().getAllAddressSpaces()) {
                if (!space.isOverlaySpace()) continue;
                this.onSpaceAddedCheckTransfer(trace, space);
            }
        } else if (guestSpace.isMemorySpace()) {
            if (guestSpace.isOverlaySpace()) {
                return;
            }
            this.onMappingAddedCheckTransferMemoryMapped(root, mapped);
        } else {
            throw new AssertionError();
        }
    }

    public void processEvent(TraceChangeRecord<?, ?> event) {
        HANDLER.handleTraceChangeRecord(event);
    }

    private void objectValueCreated(TraceObjectValue objectValue) {
        this.onValueCreatedCheckTransfer(objectValue);
    }

    private void symbolAdded(TraceSymbol symbol) {
        this.onSymbolAddedCheckTransfer(symbol);
    }

    private void spaceAdded(Trace trace, AddressSpace isNull, AddressSpace space) {
        this.onSpaceAddedCheckTransfer(trace, space);
    }

    private void guestMappingAdded(TraceGuestPlatform guest, TraceGuestPlatformMappedRange isNull, TraceGuestPlatformMappedRange mapped) {
        this.onMappingAddedCheckTransfer(mapped);
    }

    private static /* synthetic */ DBTraceObjectRegisterSupport[] $values() {
        return new DBTraceObjectRegisterSupport[]{INSTANCE};
    }

    static {
        $VALUES = DBTraceObjectRegisterSupport.$values();
        HANDLER = new TraceDomainObjectListener(){
            {
                this.listenFor(TraceEvents.VALUE_CREATED, INSTANCE::objectValueCreated);
                this.listenFor(TraceEvents.SYMBOL_ADDED, INSTANCE::symbolAdded);
                this.listenFor(TraceEvents.OVERLAY_ADDED, INSTANCE::spaceAdded);
                this.listenFor(TraceEvents.PLATFORM_MAPPING_ADDED, INSTANCE::guestMappingAdded);
            }
        };
    }
}

