/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.file.formats.android.oat.bundle;

import java.util.List;

import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.vdex.VdexHeader;

/**
 * An empty implementation used for initial
 * loading of the OAT header.
 */
public class EmptyOatBundle implements OatBundle {

	private OatHeader oatHeader;

	EmptyOatBundle(OatHeader oatHeader) {
		this.oatHeader = oatHeader;
	}

	@Override
	public void close() {
		oatHeader = null;
	}

	@Override
	public OatHeader getOatHeader() {
		return oatHeader;
	}

	@Override
	public ArtHeader getArtHeader() {
		return null;
	}

	@Override
	public VdexHeader getVdexHeader() {
		return null;
	}

	@Override
	public List<DexHeader> getDexHeaders() {
		return null;
	}

	@Override
	public DexHeader getDexHeaderByChecksum(int checksum) {
		return null;
	}

}
