/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.control;

import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.datastruct.ListenerSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@PluginInfo(shortDescription="Debugger control and machine-state editing service plugin", description="Centralizes control and machine-state editing across the tool", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerEmulationService.class}, servicesProvided={DebuggerControlService.class})
public class DebuggerControlServicePlugin
extends AbstractDebuggerPlugin
implements DebuggerControlService {
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final Map<Trace, ControlMode> currentModes = new HashMap<Trace, ControlMode>();
    private final ListenerSet<DebuggerControlService.ControlModeChangeListener> listeners = new ListenerSet(DebuggerControlService.ControlModeChangeListener.class, true);

    public DebuggerControlServicePlugin(PluginTool tool) {
        super(tool);
    }

    protected void dispose() {
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlMode getCurrentMode(Trace trace) {
        Map<Trace, ControlMode> map = this.currentModes;
        synchronized (map) {
            return this.currentModes.getOrDefault(Objects.requireNonNull(trace), ControlMode.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentMode(Trace trace, ControlMode newMode) {
        ControlMode oldMode;
        Map<Trace, ControlMode> map = this.currentModes;
        synchronized (map) {
            oldMode = this.currentModes.getOrDefault(Objects.requireNonNull(trace), ControlMode.DEFAULT);
            if (newMode != oldMode) {
                this.currentModes.put(trace, newMode);
            }
        }
        if (newMode != oldMode) {
            ((DebuggerControlService.ControlModeChangeListener)this.listeners.invoke()).modeChanged(trace, newMode);
            this.tool.contextChanged(null);
        }
    }

    public void addModeChangeListener(DebuggerControlService.ControlModeChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeModeChangeListener(DebuggerControlService.ControlModeChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public DebuggerControlService.StateEditor createStateEditor(DebuggerCoordinates coordinates) {
        return new DefaultStateEditor(coordinates);
    }

    public DebuggerControlService.StateEditor createStateEditor(Trace trace) {
        return new FollowsManagerStateEditor(trace);
    }

    public DebuggerControlService.StateEditor createStateEditor(TraceProgramView view) {
        return new FollowsViewStateEditor(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coordinatesActivated(DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        ControlMode newMode;
        ControlMode oldMode;
        if (cause != DebuggerTraceManagerService.ActivationCause.USER) {
            return;
        }
        Trace trace = coordinates.getTrace();
        if (trace == null) {
            return;
        }
        Map<Trace, ControlMode> map = this.currentModes;
        synchronized (map) {
            oldMode = this.currentModes.getOrDefault(trace, ControlMode.DEFAULT);
            newMode = oldMode.modeOnChange(coordinates);
            if (newMode != oldMode) {
                this.currentModes.put(trace, newMode);
            }
        }
        if (newMode != oldMode) {
            ((DebuggerControlService.ControlModeChangeListener)this.listeners.invoke()).modeChanged(trace, newMode);
            this.tool.contextChanged(null);
        }
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.coordinatesActivated(ev.getActiveCoordinates(), ev.getCause());
        }
    }

    protected class DefaultStateEditor
    extends AbstractStateEditor {
        private final DebuggerCoordinates coordinates;

        public DefaultStateEditor(DebuggerCoordinates coordinates) {
            this.coordinates = Objects.requireNonNull(coordinates);
        }

        public DebuggerControlService getService() {
            return DebuggerControlServicePlugin.this;
        }

        public DebuggerCoordinates getCoordinates() {
            return this.coordinates;
        }
    }

    protected class FollowsManagerStateEditor
    extends AbstractStateEditor {
        private final Trace trace;

        public FollowsManagerStateEditor(Trace trace) {
            this.trace = trace;
        }

        public DebuggerControlService getService() {
            return DebuggerControlServicePlugin.this;
        }

        public DebuggerCoordinates getCoordinates() {
            if (!DebuggerControlServicePlugin.this.traceManager.getOpenTraces().contains(this.trace)) {
                throw new IllegalStateException("Trace " + String.valueOf(this.trace) + " is not opened in the trace manager.");
            }
            return DebuggerControlServicePlugin.this.traceManager.resolveTrace(this.trace);
        }
    }

    public class FollowsViewStateEditor
    extends AbstractStateEditor {
        private final TraceProgramView view;

        public FollowsViewStateEditor(TraceProgramView view) {
            this.view = view;
        }

        public DebuggerControlService getService() {
            return DebuggerControlServicePlugin.this;
        }

        public DebuggerCoordinates getCoordinates() {
            return DebuggerControlServicePlugin.this.traceManager.resolveView(this.view);
        }
    }

    protected abstract class AbstractStateEditor
    implements DebuggerControlService.StateEditor {
        protected AbstractStateEditor() {
        }

        public boolean isVariableEditable(Address address, int length) {
            DebuggerCoordinates coordinates = this.getCoordinates();
            Trace trace = coordinates.getTrace();
            return DebuggerControlServicePlugin.this.getCurrentMode(trace).isVariableEditable(coordinates, address, length);
        }

        public CompletableFuture<Void> setVariable(Address address, byte[] data) {
            DebuggerCoordinates coordinates = this.getCoordinates();
            Trace trace = coordinates.getTrace();
            return DebuggerControlServicePlugin.this.getCurrentMode(trace).setVariable(DebuggerControlServicePlugin.this.tool, coordinates, address, data);
        }
    }
}

