/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.PCodeCfgGraphTask;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;

public class PCodeCfgAction
extends AbstractDecompilerAction {
    public PCodeCfgAction() {
        super("Graph PCode Control Flow");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ControlFlowGraph"));
        this.setMenuBarData(new MenuData(new String[]{"Graph Control Flow"}, "graph"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return context.getFunction() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        PluginTool tool = context.getTool();
        GraphDisplayBroker service = (GraphDisplayBroker)tool.getService(GraphDisplayBroker.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"AST Graph Failed", (Object)"Graph consumer not found: Please add a graph consumer provider to your tool");
            return;
        }
        ToolOptions options = tool.getOptions("Graph");
        boolean reuseGraph = options.getBoolean("Reuse Graph", false);
        int codeLimitPerBlock = options.getInt("Max Code Lines Displayed", 10);
        HighFunction highFunction = context.getHighFunction();
        Address locationAddr = context.getLocation().getAddress();
        PCodeCfgGraphTask task = new PCodeCfgGraphTask(tool, service, !reuseGraph, codeLimitPerBlock, locationAddr, highFunction, PCodeCfgGraphTask.PcodeGraphSubType.CONTROL_FLOW_GRAPH);
        new TaskLauncher((Task)task, (Component)tool.getToolFrame());
    }
}

