/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.editors;

import docking.widgets.table.RowObjectTableModel;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.editors.MatchTagComboBox;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class MatchTagCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private MatchTagComboBox matchTagChoices;
    private JTable table;
    private final VTController controller;
    private VTMatchTag tag;

    public MatchTagCellEditor(VTController controller) {
        this.controller = controller;
    }

    @Override
    public Component getTableCellEditorComponent(JTable theTable, Object value, boolean isSelected, int row, int column) {
        this.table = theTable;
        TableModel model = this.table.getModel();
        RowObjectTableModel matchModel = (RowObjectTableModel)model;
        VTMatch match = (VTMatch)matchModel.getRowObject(row);
        ArrayList<VTMatch> matches = new ArrayList<VTMatch>();
        matches.add(match);
        VTSession session = this.controller.getSession();
        this.tag = match.getTag();
        this.matchTagChoices = new MatchTagComboBox(session, matches, theTable, this.tag);
        this.matchTagChoices.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MatchTagCellEditor.this.stopCellEditing();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MatchTagCellEditor.this.matchTagChoices.showPopup();
                MatchTagCellEditor.this.matchTagChoices.requestFocus();
            }
        });
        return this.matchTagChoices;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public Object getCellEditorValue() {
        return this.matchTagChoices.getText();
    }

    @Override
    public boolean stopCellEditing() {
        ListSelectionModel columnSelectionModel = this.table.getColumnModel().getSelectionModel();
        columnSelectionModel.setValueIsAdjusting(true);
        int columnAnchor = columnSelectionModel.getAnchorSelectionIndex();
        int columnLead = columnSelectionModel.getLeadSelectionIndex();
        VTMatchTag editedTag = (VTMatchTag)this.matchTagChoices.getSelectedItem();
        if (SystemUtilities.isEqual((Object)editedTag, (Object)this.tag)) {
            this.fireEditingCanceled();
            return true;
        }
        this.tag = editedTag;
        this.matchTagChoices.apply();
        this.fireEditingStopped();
        columnSelectionModel.setAnchorSelectionIndex(columnAnchor);
        columnSelectionModel.setLeadSelectionIndex(columnLead);
        columnSelectionModel.setValueIsAdjusting(false);
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (this.controller.getSession() == null) {
            return false;
        }
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }
}

