/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBRecord;
import ghidra.feature.vt.api.db.AssociationDatabaseManager;
import ghidra.feature.vt.api.db.VTAssociationTableDBAdapter;
import ghidra.feature.vt.api.impl.MarkupItemManagerImpl;
import ghidra.feature.vt.api.impl.VTEvent;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTAssociationMarkupStatus;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;

public class VTAssociationDB
extends DatabaseObject
implements VTAssociation {
    public DBRecord record;
    private MarkupItemManagerImpl markupManager;
    public final AssociationDatabaseManager associationDBM;

    public VTAssociationDB(AssociationDatabaseManager associationManager, DBObjectCache<VTAssociationDB> cache, DBRecord record) {
        super(cache, record.getKey());
        this.associationDBM = associationManager;
        this.record = record;
        this.markupManager = new MarkupItemManagerImpl(this);
    }

    public void setInvalid() {
        super.setInvalid();
        this.markupManager.clearCache();
    }

    public VTAssociationManager getAssociationManager() {
        return this.associationDBM;
    }

    public AssociationDatabaseManager getAssociationDatabaseManager() {
        return this.associationDBM;
    }

    public AssociationDatabaseManager getAssociationManagerDB() {
        return this.associationDBM;
    }

    @Override
    public VTSession getSession() {
        return this.associationDBM.getSession();
    }

    @Override
    public Collection<VTAssociation> getRelatedAssociations() {
        return this.associationDBM.getRelatedAssociationsBySourceAndDestinationAddress(this.getSourceAddress(), this.getDestinationAddress());
    }

    protected boolean refresh() {
        return this.refresh(null);
    }

    protected boolean refresh(DBRecord associationRecord) {
        if (associationRecord == null) {
            associationRecord = this.associationDBM.getAssociationRecord(this.key);
        }
        if (associationRecord == null) {
            return false;
        }
        this.record = associationRecord;
        return true;
    }

    @Override
    public Address getSourceAddress() {
        this.associationDBM.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.associationDBM.getSourceAddressFromLong(this.record.getLongValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.SOURCE_ADDRESS_COL.column()));
            return address;
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    @Override
    public Address getDestinationAddress() {
        this.associationDBM.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.associationDBM.getDestinationAddressFromLong(this.record.getLongValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.DESTINATION_ADDRESS_COL.column()));
            return address;
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    @Override
    public VTAssociationType getType() {
        this.associationDBM.lock.acquire();
        try {
            this.checkIsValid();
            byte associationTypeOrdinal = this.record.getByteValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.TYPE_COL.column());
            VTAssociationType vTAssociationType = VTAssociationType.values()[associationTypeOrdinal];
            return vTAssociationType;
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    public void markupItemStatusChanged(VTMarkupItem markupItem) {
        this.associationDBM.markupItemStatusChanged(markupItem);
    }

    @Override
    public VTAssociationStatus getStatus() {
        this.associationDBM.lock.acquire();
        try {
            this.checkIsValid();
            VTAssociationStatus vTAssociationStatus = VTAssociationStatus.values()[this.record.getByteValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.STATUS_COL.column())];
            return vTAssociationStatus;
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    @Override
    public VTAssociationMarkupStatus getMarkupStatus() {
        this.associationDBM.lock.acquire();
        try {
            this.checkIsValid();
            VTAssociationMarkupStatus vTAssociationMarkupStatus = new VTAssociationMarkupStatus(this.record.getByteValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.APPLIED_STATUS_COL.column()));
            return vTAssociationMarkupStatus;
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    DBRecord getRecord() {
        this.associationDBM.lock.acquire();
        try {
            this.checkIsValid();
            DBRecord dBRecord = this.record;
            return dBRecord;
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    public String toString() {
        return "VTAssociation[" + String.valueOf(this.getSourceAddress()) + " <-> " + String.valueOf(this.getDestinationAddress()) + "]";
    }

    public int hashCode() {
        return this.getSourceAddress().hashCode() + this.getDestinationAddress().hashCode();
    }

    @Override
    public void setAccepted() throws VTAssociationStatusException {
        this.associationDBM.setAssociationAccepted(this);
    }

    @Override
    public void setRejected() throws VTAssociationStatusException {
        VTAssociationStatus status = this.getStatus();
        if (status == VTAssociationStatus.REJECTED) {
            return;
        }
        if (status == VTAssociationStatus.ACCEPTED) {
            throw new VTAssociationStatusException("Can't reject an already accepted association");
        }
        this.setStatus(VTAssociationStatus.REJECTED);
    }

    @Override
    public void clearStatus() throws VTAssociationStatusException {
        this.associationDBM.clearAcceptedAssociation(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VTAssociation)) {
            return false;
        }
        VTAssociation other = (VTAssociation)obj;
        return this.getSourceAddress().equals((Object)other.getSourceAddress()) && this.getDestinationAddress().equals((Object)other.getDestinationAddress());
    }

    @Override
    public int getVoteCount() {
        this.associationDBM.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.record.getIntValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.VOTE_COUNT_COL.column());
            return n;
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    @Override
    public void setMarkupStatus(VTAssociationMarkupStatus status) {
        this.associationDBM.lock.acquire();
        try {
            this.checkDeleted();
            VTAssociationMarkupStatus existingStatus = this.getMarkupStatus();
            if (status.equals(existingStatus)) {
                return;
            }
            this.record.setByteValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.APPLIED_STATUS_COL.column(), (byte)status.getStatusValue());
            this.associationDBM.updateAssociationRecord(this.record);
            this.associationDBM.getSession().setObjectChanged(VTEvent.ASSOCIATION_MARKUP_STATUS_CHANGED, this, existingStatus, status);
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    public void setStatus(VTAssociationStatus status) {
        this.associationDBM.lock.acquire();
        try {
            this.checkDeleted();
            VTAssociationStatus existingStatus = this.getStatus();
            if (status == existingStatus) {
                return;
            }
            this.record.setByteValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.STATUS_COL.column(), (byte)status.ordinal());
            this.associationDBM.updateAssociationRecord(this.record);
            this.associationDBM.getSession().setObjectChanged(VTEvent.ASSOCIATION_STATUS_CHANGED, this, (Object)existingStatus, (Object)status);
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    @Override
    public void setVoteCount(int voteCount) {
        this.associationDBM.lock.acquire();
        try {
            this.checkDeleted();
            voteCount = Math.max(0, voteCount);
            this.record.setIntValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.VOTE_COUNT_COL.column(), voteCount);
            this.associationDBM.updateAssociationRecord(this.record);
            this.associationDBM.getSession().setObjectChanged(VTEvent.VOTE_COUNT_CHANGED, this, null, null);
        }
        finally {
            this.associationDBM.lock.release();
        }
    }

    @Override
    public Collection<VTMarkupItem> getMarkupItems(TaskMonitor monitor) throws CancelledException {
        return this.markupManager.getMarkupItems(monitor);
    }

    @Override
    public boolean hasAppliedMarkupItems() {
        return this.markupManager.hasAppliedMarkupItems();
    }

    void removeMarkupItems() {
        this.markupManager.removeMarkupItems();
    }
}

