/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.algorithms.BalloonLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.RadialTreeLayout;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.PolarPoint;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.transform.shape.ShapeTransformer;

public interface LayoutPaintable {

    public static class RadialRings<V>
    implements VisualizationServer.Paintable {
        Collection<Double> depths;
        LayoutModel<V> layoutModel;
        VisualizationServer<V, ?> vv;
        RadialTreeLayout<V> radialTreeLayoutAlgorithm;

        public RadialRings(VisualizationServer<V, ?> vv, RadialTreeLayout<V> radialTreeLayoutAlgorithm) {
            this.vv = vv;
            this.layoutModel = vv.getVisualizationModel().getLayoutModel();
            this.radialTreeLayoutAlgorithm = radialTreeLayoutAlgorithm;
        }

        private Collection<Double> getDepths() {
            HashSet<Double> depths = new HashSet<Double>();
            Map polarLocations = this.radialTreeLayoutAlgorithm.getPolarLocations();
            for (Object v : this.vv.getVisualizationModel().getGraph().vertexSet()) {
                PolarPoint pp = (PolarPoint)polarLocations.get(v);
                depths.add(pp.radius);
            }
            return depths;
        }

        @Override
        public void paint(Graphics g) {
            if (this.depths == null) {
                this.depths = this.getDepths();
            }
            g.setColor(Color.lightGray);
            Graphics2D g2d = (Graphics2D)g;
            Point center = this.radialTreeLayoutAlgorithm.getCenter(this.layoutModel);
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (double d : this.depths) {
                ellipse.setFrameFromDiagonal(center.x - d, center.y - d, center.x + d, center.y + d);
                Shape shape = this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).transform(ellipse);
                g2d.draw(shape);
            }
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }

    public static class BalloonRings<V, E>
    implements VisualizationServer.Paintable {
        BalloonLayoutAlgorithm<V> layoutAlgorithm;
        VisualizationServer<V, E> vv;

        public BalloonRings(VisualizationServer<V, E> vv, BalloonLayoutAlgorithm<V> layoutAlgorithm) {
            this.vv = vv;
            this.layoutAlgorithm = layoutAlgorithm;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.gray);
            Graphics2D g2d = (Graphics2D)g;
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (Object v : this.vv.getVisualizationModel().getGraph().vertexSet()) {
                Double radius = (Double)this.layoutAlgorithm.getRadii().get(v);
                if (radius == null) continue;
                Point p = (Point)this.vv.getVisualizationModel().getLayoutModel().apply(v);
                ((RectangularShape)ellipse).setFrame(-radius.doubleValue(), -radius.doubleValue(), 2.0 * radius, 2.0 * radius);
                AffineTransform at = AffineTransform.getTranslateInstance(p.x, p.y);
                Shape shape = at.createTransformedShape(ellipse);
                shape = this.vv.getTransformSupport().transform(this.vv, shape);
                g2d.draw(shape);
            }
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }

    public static class TreeCells<V>
    implements VisualizationServer.Paintable {
        Map<V, Rectangle> cellMap;
        LayoutModel<V> layoutModel;
        private ShapeTransformer transformer;
        Color color = Color.cyan;

        public TreeCells(LayoutModel<V> layoutModel, Map<V, Rectangle> cellMap, ShapeTransformer transformer) {
            this(layoutModel, cellMap, transformer, Color.cyan);
        }

        public TreeCells(LayoutModel<V> layoutModel, Map<V, Rectangle> cellMap, ShapeTransformer transformer, Color color) {
            this.layoutModel = layoutModel;
            this.cellMap = cellMap;
            this.transformer = transformer;
            this.color = color;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            for (Object vertex : this.layoutModel.getGraph().vertexSet()) {
                Rectangle d = this.cellMap.getOrDefault(vertex, Rectangle.IDENTITY);
                Point p = (Point)this.layoutModel.apply(vertex);
                Shape r = new Rectangle2D.Double(d.x, d.y, d.width, d.height);
                r = this.transformer.transform(r);
                g2d.setPaint(this.color);
                g2d.draw(r);
            }
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }

    public static class Grid
    implements VisualizationServer.Paintable {
        int cellWidth;
        int cellHeight;
        int count;
        Color color;

        public Grid() {
            this(100, 500, 20, Color.cyan);
        }

        public Grid(int cellWidth, int cellHeight, int count, Color color) {
            this.cellWidth = cellWidth;
            this.cellHeight = cellHeight;
            this.count = count;
            this.color = color;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            for (int i = 0; i < this.count; ++i) {
                Rectangle2D.Double r = new Rectangle2D.Double(i * 100, 0.0, 100.0, 500.0);
                g2d.setPaint(this.color);
                g2d.draw(r);
            }
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }

    public static class LayoutBounds
    implements VisualizationServer.Paintable {
        private VisualizationModel visualizationModel;
        private ShapeTransformer transformer;
        private int cellWidth = 0;
        private int cellHeight = 0;
        Color color;

        public LayoutBounds(VisualizationServer visualizationServer) {
            this(visualizationServer.getVisualizationModel(), visualizationServer.getRenderContext().getMultiLayerTransformer());
        }

        public LayoutBounds(VisualizationServer visualizationServer, int cellWidth, int cellHeight) {
            this(visualizationServer.getVisualizationModel(), visualizationServer.getRenderContext().getMultiLayerTransformer(), cellWidth, cellHeight, Color.cyan);
        }

        public LayoutBounds(VisualizationModel visualizationModel, ShapeTransformer transformer) {
            this(visualizationModel, transformer, 0, 0, Color.blue);
        }

        public LayoutBounds(VisualizationModel visualizationModel, ShapeTransformer transformer, Color color) {
            this.visualizationModel = visualizationModel;
            this.transformer = transformer;
            this.color = color;
        }

        public LayoutBounds(VisualizationModel visualizationModel, ShapeTransformer transformer, int cellWidth, int cellHeight, Color color) {
            this.visualizationModel = visualizationModel;
            this.transformer = transformer;
            this.cellWidth = cellWidth;
            this.cellHeight = cellHeight;
            this.color = color;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(this.color);
            Shape layoutRectangle = new Rectangle2D.Double(0.0, 0.0, this.visualizationModel.getLayoutSize().width, this.visualizationModel.getLayoutSize().height);
            int width = layoutRectangle.getBounds().width;
            int height = layoutRectangle.getBounds().height;
            layoutRectangle = this.transformer.transform(layoutRectangle);
            g2d.draw(layoutRectangle);
            g2d.drawString(width + " x " + height, 20, 20);
        }

        public void paintGrid(Graphics g) {
            int horizontalCount = this.visualizationModel.getLayoutSize().width / this.cellWidth;
            int verticalCount = this.visualizationModel.getLayoutSize().height / this.cellHeight;
            Graphics2D g2d = (Graphics2D)g;
            for (int i = 0; i < verticalCount; ++i) {
                for (int j = 0; j < horizontalCount; ++j) {
                    Shape r = new Rectangle2D.Double(i * this.cellWidth, j * this.cellHeight, this.cellWidth, this.cellHeight);
                    r = this.transformer.transform(r);
                    g2d.setPaint(this.color);
                    g2d.draw(r);
                }
            }
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }
}

