/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitBinOp;
import org.objectweb.asm.MethodVisitor;

public interface BinOpGen<T extends JitBinOp>
extends OpGen<T> {
    /*
     * Unable to fully structure code
     */
    public static void generateMpDelegationToStaticMethod(JitCodeGenerator gen, JitType.MpIntJitType type, String methodName, MethodVisitor mv, int overProvisionLeft, TakeOut takeOut) {
        am = gen.getAllocationModel();
        legCount = type.legsAlloc();
        tmpL = am.allocateTemp(mv, "tmpL", legCount);
        try {
            tmpR = am.allocateTemp(mv, "tmpR", legCount);
            try {
                OpGen.generateMpLegsIntoTemp(tmpR, legCount, mv);
                OpGen.generateMpLegsIntoTemp(tmpL, legCount, mv);
                switch (takeOut.ordinal()) {
                    case 0: {
                        mv.visitLdcInsn((Object)legCount);
                        mv.visitIntInsn(188, 10);
                        mv.visitInsn(89);
                        OpGen.generateMpLegsIntoArray(tmpL, legCount + overProvisionLeft, legCount, mv);
                        OpGen.generateMpLegsIntoArray(tmpR, legCount, legCount, mv);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        mv.visitLdcInsn((Object)legCount);
                        mv.visitIntInsn(188, 10);
                        OpGen.generateMpLegsIntoArray(tmpL, legCount + overProvisionLeft, legCount, mv);
                        mv.visitInsn(90);
                        OpGen.generateMpLegsIntoArray(tmpR, legCount, legCount, mv);
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            finally {
                if (tmpR != null) {
                    tmpR.close();
                }
            }
        }
        finally {
            if (tmpL != null) {
                tmpL.close();
            }
        }
        mv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, methodName, GenConsts.MDESC_JIT_COMPILED_PASSAGE__MP_INT_BINOP, true);
        OpGen.generateMpLegsFromArray(legCount, mv);
    }

    public boolean isSigned();

    default public TypeConversions.Ext ext() {
        return TypeConversions.Ext.forSigned(this.isSigned());
    }

    default public TypeConversions.Ext rExt() {
        return this.ext();
    }

    default public JitType afterLeft(JitCodeGenerator gen, T op, JitType lType, JitType rType, MethodVisitor rv) {
        return lType;
    }

    public JitType generateBinOpRunCode(JitCodeGenerator var1, T var2, JitControlFlowModel.JitBlock var3, JitType var4, JitType var5, MethodVisitor var6);

    @Override
    default public void generateRunCode(JitCodeGenerator gen, T op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        JitType lType = gen.generateValReadCode(op.l(), op.lType(), this.ext());
        JitType rType = op.rType().resolve(gen.getTypeModel().typeOf(op.r()));
        lType = this.afterLeft(gen, op, lType, rType, rv);
        JitType checkRType = gen.generateValReadCode(op.r(), op.rType(), this.rExt());
        if (!1.$assertionsDisabled && checkRType != rType) {
            throw new AssertionError();
        }
        JitType outType = this.generateBinOpRunCode(gen, op, block, lType, rType, rv);
        gen.generateVarWriteCode(op.out(), outType, TypeConversions.Ext.ZERO);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum TakeOut {
        OUT,
        LEFT;

    }
}

