/*
 * Decompiled with CFR 0.152.
 */
package utility.application;

import generic.jar.ResourceFile;
import ghidra.framework.ApplicationIdentifier;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.OperatingSystem;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SequencedCollection;
import utilities.util.FileUtilities;

public class ApplicationUtilities {
    public static final String PROPERTY_TEMP_DIR = "application.tempdir";
    public static final String PROPERTY_CACHE_DIR = "application.cachedir";
    public static final String PROPERTY_SETTINGS_DIR = "application.settingsdir";

    public static SequencedCollection<ResourceFile> findDefaultApplicationRootDirs() {
        ArrayList<ResourceFile> applicationRootDirs = new ArrayList<ResourceFile>();
        ResourceFile applicationRootDir = ApplicationUtilities.findPrimaryApplicationRootDir();
        if (applicationRootDir != null) {
            applicationRootDirs.add(applicationRootDir);
            if (SystemUtilities.isInTestingMode() || SystemUtilities.isInDevelopmentMode()) {
                applicationRootDirs.addAll(ApplicationUtilities.findApplicationRootDirsFromRepoConfig(applicationRootDir));
            }
        }
        return applicationRootDirs;
    }

    private static ResourceFile findPrimaryApplicationRootDir() {
        String[] classpath;
        for (String pathEntry : classpath = System.getProperty("java.class.path").split(File.pathSeparator)) {
            try {
                for (ResourceFile pathFile = new ResourceFile(new File(pathEntry).getCanonicalPath()); pathFile != null && pathFile.exists(); pathFile = pathFile.getParentFile()) {
                    ResourceFile applicationPropertiesFile = new ResourceFile(pathFile, "application.properties");
                    if (!ApplicationUtilities.validateApplicationPropertiesFile(applicationPropertiesFile)) continue;
                    return pathFile;
                }
            }
            catch (IOException e) {
                Msg.error(ApplicationUtilities.class, "Invalid class path entry: " + pathEntry, e);
            }
        }
        return null;
    }

    private static boolean validateApplicationPropertiesFile(ResourceFile applicationPropertiesFile) {
        if (applicationPropertiesFile.isFile()) {
            try {
                ApplicationProperties applicationProperties = new ApplicationProperties(applicationPropertiesFile);
                if (!applicationProperties.getApplicationName().isEmpty()) {
                    return true;
                }
            }
            catch (IOException e) {
                Msg.error(ApplicationUtilities.class, "Failed to read: " + String.valueOf(applicationPropertiesFile), e);
            }
        }
        return false;
    }

    private static SequencedCollection<ResourceFile> findApplicationRootDirsFromRepoConfig(ResourceFile primaryApplicationRootDir) {
        ArrayList<ResourceFile> repoApplicationRootDirs = new ArrayList<ResourceFile>();
        ResourceFile repoConfigFile = new ResourceFile(primaryApplicationRootDir.getParentFile(), "ghidra.repos.config");
        if (repoConfigFile.isFile()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(repoConfigFile.getFile(false)));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    ResourceFile potentialApplicationRootDir;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || !(potentialApplicationRootDir = new ResourceFile(repoConfigFile.getParentFile().getParentFile(), line + File.separator + "Ghidra")).isDirectory()) continue;
                    repoApplicationRootDirs.add(potentialApplicationRootDir);
                }
            }
            catch (IOException e) {
                Msg.error(ApplicationUtilities.class, "Failed to read: " + String.valueOf(repoConfigFile));
            }
        }
        return repoApplicationRootDirs;
    }

    public static File getDefaultUserTempDir(String applicationName) throws FileNotFoundException, IOException {
        String appName = ApplicationUtilities.normalizeApplicationName(applicationName);
        File tempOverrideDir = ApplicationUtilities.getSystemPropertyFile(PROPERTY_TEMP_DIR, false);
        if (tempOverrideDir != null) {
            return ApplicationUtilities.createDir(new File(tempOverrideDir, ApplicationUtilities.getUserSpecificDirName(tempOverrideDir, appName)));
        }
        File javaTmpDir = ApplicationUtilities.getJavaTmpDir();
        return ApplicationUtilities.createDir(new File(ApplicationUtilities.getJavaTmpDir(), ApplicationUtilities.getUserSpecificDirName(javaTmpDir, appName)));
    }

    public static File getDefaultUserCacheDir(ApplicationProperties applicationProperties) throws FileNotFoundException, IOException {
        String appName = ApplicationUtilities.normalizeApplicationName(applicationProperties.getApplicationName());
        File cacheOverrideDir = ApplicationUtilities.getSystemPropertyFile(PROPERTY_CACHE_DIR, false);
        if (cacheOverrideDir != null) {
            return ApplicationUtilities.createDir(new File(cacheOverrideDir, ApplicationUtilities.getUserSpecificDirName(cacheOverrideDir, appName)));
        }
        File xdgCacheHomeDir = ApplicationUtilities.getEnvFile("XDG_CACHE_HOME", false);
        if (xdgCacheHomeDir != null) {
            return ApplicationUtilities.createDir(new File(xdgCacheHomeDir, ApplicationUtilities.getUserSpecificDirName(xdgCacheHomeDir, appName)));
        }
        String userDirName = SystemUtilities.getUserName() + "-" + appName;
        try {
            return ApplicationUtilities.createDir(switch (OperatingSystem.CURRENT_OPERATING_SYSTEM) {
                case OperatingSystem.WINDOWS -> new File(ApplicationUtilities.getEnvFile("LOCALAPPDATA", true), appName);
                case OperatingSystem.LINUX -> new File("/var/tmp/" + userDirName);
                case OperatingSystem.FREE_BSD -> new File("/var/tmp/" + userDirName);
                case OperatingSystem.MAC_OS_X -> new File("/var/tmp/" + userDirName);
                default -> throw new FileNotFoundException("Failed to find the user cache directory: Unsupported operating system.");
            });
        }
        catch (IOException e) {
            return ApplicationUtilities.getDefaultUserTempDir(applicationProperties.getApplicationName());
        }
    }

    public static File getDefaultUserSettingsDir(ApplicationProperties applicationProperties, ResourceFile installationDirectory) throws FileNotFoundException, IOException {
        File settingsOverrideDir;
        ApplicationIdentifier applicationIdentifier = new ApplicationIdentifier(applicationProperties);
        String appName = applicationIdentifier.getApplicationName();
        Object versionedName = applicationIdentifier.toString();
        if (SystemUtilities.isInDevelopmentMode()) {
            versionedName = (String)versionedName + "_location_" + installationDirectory.getName();
        }
        if ((settingsOverrideDir = ApplicationUtilities.getSystemPropertyFile(PROPERTY_SETTINGS_DIR, false)) != null) {
            return ApplicationUtilities.createDir(new File(settingsOverrideDir, ApplicationUtilities.getUserSpecificDirName(settingsOverrideDir, appName) + "/" + (String)versionedName));
        }
        File xdgConfigHomeDir = ApplicationUtilities.getEnvFile("XDG_CONFIG_HOME", false);
        if (xdgConfigHomeDir != null) {
            return ApplicationUtilities.createDir(new File(xdgConfigHomeDir, ApplicationUtilities.getUserSpecificDirName(xdgConfigHomeDir, appName) + "/" + (String)versionedName));
        }
        File userHomeDir = ApplicationUtilities.getJavaUserHomeDir();
        String versionedSubdir = appName + "/" + (String)versionedName;
        return ApplicationUtilities.createDir(switch (OperatingSystem.CURRENT_OPERATING_SYSTEM) {
            case OperatingSystem.WINDOWS -> new File(ApplicationUtilities.getEnvFile("APPDATA", true), versionedSubdir);
            case OperatingSystem.LINUX -> new File(userHomeDir, ".config/" + versionedSubdir);
            case OperatingSystem.FREE_BSD -> new File(userHomeDir, ".config/" + versionedSubdir);
            case OperatingSystem.MAC_OS_X -> new File(userHomeDir, "Library/" + versionedSubdir);
            default -> throw new FileNotFoundException("Failed to find the user settings directory: Unsupported operating system.");
        });
    }

    public static File getLegacyUserSettingsDir(ApplicationProperties applicationProperties, ResourceFile installationDirectory) throws FileNotFoundException {
        ApplicationIdentifier applicationIdentifier = new ApplicationIdentifier(applicationProperties);
        File userSettingsParentDir = new File(ApplicationUtilities.getJavaUserHomeDir(), "." + applicationIdentifier.getApplicationName());
        String userSettingsDirName = "." + String.valueOf(applicationIdentifier);
        if (SystemUtilities.isInDevelopmentMode()) {
            userSettingsDirName = userSettingsDirName + "_location_" + installationDirectory.getName();
        }
        return new File(userSettingsParentDir, userSettingsDirName);
    }

    public static String normalizeApplicationName(String applicationName) {
        return applicationName.replaceAll("\\s", "").toLowerCase();
    }

    private static File getJavaTmpDir() throws FileNotFoundException {
        return ApplicationUtilities.getSystemPropertyFile("java.io.tmpdir", true);
    }

    private static File getJavaUserHomeDir() throws FileNotFoundException {
        return ApplicationUtilities.getSystemPropertyFile("user.home", true);
    }

    private static File getSystemPropertyFile(String name, boolean required) throws FileNotFoundException {
        String path = System.getProperty(name);
        if (path == null || path.isBlank()) {
            if (required) {
                throw new FileNotFoundException("Required system property \"%s\" is not set!".formatted(name));
            }
            return null;
        }
        File file = new File(path = path.trim());
        if (!file.isAbsolute()) {
            throw new FileNotFoundException("System property \"%s\" is not an absolute path: \"%s\"".formatted(name, path));
        }
        return file;
    }

    private static File getEnvFile(String name, boolean required) throws FileNotFoundException {
        String path = System.getenv(name);
        if (path == null || path.isBlank()) {
            if (required) {
                throw new FileNotFoundException("Required environment variable \"%s\" is not set!".formatted(name));
            }
            return null;
        }
        File file = new File(path = path.trim());
        if (!file.isAbsolute()) {
            throw new FileNotFoundException("Environment variable \"%s\" is not an absolute path: \"%s\"".formatted(name, path));
        }
        return file;
    }

    private static String getUserSpecificDirName(File parentDir, String appName) throws FileNotFoundException {
        Object userSpecificDirName = appName;
        if (!FileUtilities.isPathContainedWithin(ApplicationUtilities.getJavaUserHomeDir(), parentDir)) {
            userSpecificDirName = SystemUtilities.getUserName() + "-" + appName;
        }
        return userSpecificDirName;
    }

    private static File createDir(File dir) throws IOException {
        if (dir != null) {
            if (!FileUtilities.mkdirs(dir)) {
                throw new IOException("Failed to create directory: " + String.valueOf(dir));
            }
            FileUtilities.setOwnerOnlyPermissions(dir);
        }
        return dir;
    }
}

