/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.FieldIndexTable;
import db.IndexField;
import db.Table;
import db.TableRecord;
import db.TableStatistics;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class IndexTable {
    protected static final Field[] emptyKeyArray = Field.EMPTY_ARRAY;
    protected final DBHandle db;
    protected final TableRecord indexTableRecord;
    protected Table primaryTable;
    protected Table indexTable;
    protected final int indexColumn;
    protected final boolean isSparseIndex;

    IndexTable(Table primaryTable, TableRecord indexTableRecord) throws IOException {
        if (!primaryTable.useLongKeys() && !primaryTable.useFixedKeys()) {
            throw new AssertException("Only fixed-length key tables may be indexed");
        }
        this.db = primaryTable.getDBHandle();
        this.primaryTable = primaryTable;
        this.indexTableRecord = indexTableRecord;
        this.indexTable = new Table(primaryTable.getDBHandle(), indexTableRecord);
        this.indexColumn = indexTableRecord.getIndexedColumn();
        this.isSparseIndex = primaryTable.getSchema().isSparseColumn(this.indexColumn);
        primaryTable.addIndex(this);
    }

    static IndexTable getIndexTable(DBHandle db, TableRecord indexTableRecord) throws IOException {
        String name = indexTableRecord.getName();
        Table primaryTable = db.getTable(name);
        if (primaryTable == null) {
            throw new AssertException("Table not found: " + name);
        }
        Field keyFieldType = indexTableRecord.getSchema().getKeyFieldType();
        if (keyFieldType instanceof IndexField) {
            return new FieldIndexTable(primaryTable, indexTableRecord);
        }
        throw new AssertException("Unexpected index field type: " + keyFieldType.getClass().getName());
    }

    static IndexTable createIndexTable(Table primaryTable, int indexColumn) throws IOException {
        if (primaryTable.getRecordCount() != 0) {
            throw new AssertException();
        }
        return new FieldIndexTable(primaryTable, indexColumn);
    }

    boolean isConsistent(TaskMonitor monitor) throws IOException, CancelledException {
        return this.indexTable.isConsistent(this.primaryTable.getSchema().getFieldNames()[this.indexColumn], monitor);
    }

    Field getPrimaryTableKeyType() {
        return this.primaryTable.getSchema().getKeyFieldType();
    }

    long getTableNum() {
        return this.indexTable.getTableNum();
    }

    int getColumnIndex() {
        return this.indexColumn;
    }

    TableStatistics getStatistics() throws IOException {
        TableStatistics stats = this.indexTable.getStatistics();
        stats.indexColumn = this.indexColumn;
        return stats;
    }

    boolean hasRecord(Field field) throws IOException {
        return this.indexTable.hasRecord(field);
    }

    abstract Field[] findPrimaryKeys(Field var1) throws IOException;

    abstract int getKeyCount(Field var1) throws IOException;

    abstract void addEntry(DBRecord var1) throws IOException;

    abstract void deleteEntry(DBRecord var1) throws IOException;

    void deleteAll() throws IOException {
        this.indexTable.deleteAll();
    }

    abstract DBFieldIterator indexIterator() throws IOException;

    abstract DBFieldIterator indexIterator(Field var1, Field var2, boolean var3) throws IOException;

    abstract DBFieldIterator indexIterator(Field var1, Field var2, Field var3, boolean var4) throws IOException;

    abstract DBFieldIterator keyIterator() throws IOException;

    abstract DBFieldIterator keyIteratorBefore(Field var1) throws IOException;

    abstract DBFieldIterator keyIteratorAfter(Field var1) throws IOException;

    abstract DBFieldIterator keyIteratorBefore(Field var1, Field var2) throws IOException;

    abstract DBFieldIterator keyIteratorAfter(Field var1, Field var2) throws IOException;

    abstract DBFieldIterator keyIterator(Field var1, Field var2, boolean var3) throws IOException;

    abstract DBFieldIterator keyIterator(Field var1, Field var2, Field var3, boolean var4) throws IOException;
}

