/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import ghidra.app.util.bin.format.golang.structmapping.FieldMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.FieldOutputFunction;
import ghidra.app.util.bin.format.golang.structmapping.ReflectionHelper;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FieldOutputInfo<T> {
    private final FieldMappingInfo<T> fmi;
    private final String dataTypeName;
    private final int fieldOffset;
    private final boolean isVariableLength;
    private final int ordinal;
    private FieldOutputFunction<T> outputFunc;

    public FieldOutputInfo(FieldMappingInfo<T> fmi, String dataTypeName, boolean isVariableLength, int ordinal, int fieldOffset) {
        this.fmi = fmi;
        this.dataTypeName = dataTypeName;
        this.isVariableLength = isVariableLength;
        this.ordinal = ordinal;
        this.fieldOffset = fieldOffset;
    }

    public Field getField() {
        return this.fmi.getField();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public FieldOutputFunction<T> getOutputFunc() {
        return this.outputFunc;
    }

    public <R> R getValue(T structInstance, Class<R> expectedType) throws IOException {
        try {
            Object val = this.fmi.getField().get(structInstance);
            if (expectedType.isInstance(val)) {
                return expectedType.cast(val);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException(e);
        }
        return null;
    }

    public void setOutputFuncClass(Class<? extends FieldOutputFunction> funcClass, String getterName) {
        if (funcClass != FieldOutputFunction.class) {
            this.outputFunc = ReflectionHelper.createInstance(funcClass, this);
            return;
        }
        if (getterName != null && !getterName.isBlank()) {
            Method getter = ReflectionHelper.requireGetter(this.fmi.getField().getDeclaringClass(), getterName);
            getter.setAccessible(true);
            this.outputFunc = (context, structure, unused) -> this.outputFuncWithGetter(getter, context, structure);
            return;
        }
        if (this.dataTypeName != null && !this.dataTypeName.isBlank()) {
            this.outputFunc = this::dataTypeNameOutputFunc;
            return;
        }
        Class<?> fieldType = this.fmi.getField().getType();
        if (ReflectionHelper.isPrimitiveType(fieldType)) {
            this.outputFunc = this::primitiveOutputFunc;
            return;
        }
        if (fieldType.isArray() && ReflectionHelper.isPrimitiveType(fieldType.getComponentType())) {
            this.outputFunc = this::arrayOutputFunc;
            return;
        }
        if (ReflectionHelper.hasStructureMapping(fieldType)) {
            this.outputFunc = this::nestedStructureOutputFunc;
            return;
        }
        throw new IllegalArgumentException("Invalid FieldOutput " + String.valueOf(this.fmi.getField()));
    }

    private void preAddField(Structure structure) throws IOException {
        if (this.fieldOffset >= 0) {
            int currentOffset = FieldOutputInfo.getStructLength(structure);
            if (currentOffset > this.fieldOffset) {
                throw new IOException("Invalid field offset %d, structure is already %d".formatted(this.fieldOffset, currentOffset));
            }
            if (currentOffset < this.fieldOffset) {
                structure.add(Undefined.getUndefinedDataType((int)(this.fieldOffset - currentOffset)), -1);
            }
        }
    }

    private void outputFuncWithGetter(Method getter, StructureContext<T> context, Structure structure) throws IOException {
        Object getterResult = ReflectionHelper.callGetter(getter, context.getStructureInstance(), Object.class);
        if (getterResult != null) {
            if (getterResult instanceof DataType) {
                DataType dt = (DataType)getterResult;
                this.preAddField(structure);
                structure.add(dt, this.fmi.getFieldName(), null);
            } else if (getterResult instanceof DataTypeInstance) {
                DataTypeInstance dti = (DataTypeInstance)getterResult;
                this.preAddField(structure);
                structure.add(dti.getDataType(), dti.getLength(), this.fmi.getFieldName(), null);
            } else {
                throw new IOException("Bad result type for FieldOutput.getter: %s".formatted(getterResult.getClass().getSimpleName()));
            }
        }
    }

    private void dataTypeNameOutputFunc(StructureContext<T> context, Structure structure, FieldOutputInfo<T> foi) throws IOException {
        DataType dt = context.getDataTypeMapper().getType(this.dataTypeName, DataType.class);
        if (dt == null) {
            throw new IOException("Missing data type %s for field %s".formatted(this.dataTypeName, this.fmi.getFieldName()));
        }
        this.preAddField(structure);
        if (dt instanceof Dynamic) {
            throw new IOException("Invalid dynamic sized data type %s for field %s".formatted(dt.getName(), this.fmi.getFieldName()));
        }
        structure.add(dt, this.fmi.getFieldName(), null);
    }

    private void primitiveOutputFunc(StructureContext<T> context, Structure structure, FieldOutputInfo<T> foi) throws IOException {
        DataType dt = ReflectionHelper.getPrimitiveOutputDataType(this.fmi.getField().getType(), this.fmi.getLength(), this.fmi.getSignedness(), context.getDataTypeMapper());
        this.preAddField(structure);
        structure.add(dt, this.fmi.getFieldName(), null);
    }

    private void arrayOutputFunc(StructureContext<T> context, Structure structure, FieldOutputInfo<T> foi) throws IOException {
        Object fieldValue = foi.getValue(context.getStructureInstance(), Object.class);
        DataType dt = ReflectionHelper.getArrayOutputDataType(fieldValue, this.fmi.getField().getType(), this.fmi.getLength(), this.fmi.getSignedness(), context.getDataTypeMapper());
        this.preAddField(structure);
        structure.add(dt, this.fmi.getFieldName(), null);
    }

    private void nestedStructureOutputFunc(StructureContext<T> context, Structure structure, FieldOutputInfo<T> foi) throws IOException {
        Object nestedStruct = foi.getValue(context.getStructureInstance(), Object.class);
        if (nestedStruct == null) {
            return;
        }
        StructureContext<Object> nestedStructContext = context.getDataTypeMapper().getStructureContextOfInstance(nestedStruct);
        if (nestedStructContext == null) {
            throw new IOException("Missing StructureContext for " + nestedStruct.getClass().getSimpleName());
        }
        Structure nestedStructDT = nestedStructContext.getStructureDataType();
        this.preAddField(structure);
        structure.add((DataType)nestedStructDT, this.fmi.getFieldName(), null);
    }

    private static int getStructLength(Structure struct) {
        return struct.isZeroLength() ? 0 : struct.getLength();
    }
}

