/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.CoffSectionHeader;
import ghidra.app.util.bin.format.coff.CoffSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CoffRelocationContext {
    private final Program program;
    private final CoffFileHeader header;
    private final Map<CoffSymbol, Symbol> symbolsMap;
    private final Map<String, Object> contextMap = new HashMap<String, Object>();
    private CoffSectionHeader section;

    public CoffRelocationContext(Program program, CoffFileHeader header, Map<CoffSymbol, Symbol> symbolsMap) {
        this.program = program;
        this.header = header;
        this.symbolsMap = symbolsMap;
    }

    public void resetContext(CoffSectionHeader coffSection) {
        this.section = coffSection;
        this.contextMap.clear();
    }

    public Program getProgram() {
        return this.program;
    }

    public CoffSectionHeader getSection() {
        return this.section;
    }

    public Symbol getSymbol(CoffRelocation relocation) throws RelocationException {
        Symbol symbol = this.symbolsMap.get(this.header.getSymbolAtIndex(relocation.getSymbolIndex()));
        if (symbol == null) {
            throw new RelocationException("missing required symbol");
        }
        return symbol;
    }

    public Address getSymbolAddress(CoffRelocation relocation) throws RelocationException {
        return this.getSymbol(relocation).getAddress();
    }

    public Object computeContextValueIfAbsent(String key, Function<String, Object> mappingFunction) {
        return this.contextMap.computeIfAbsent(key, mappingFunction);
    }

    public void putContextValue(String key, Object value) {
        this.contextMap.put(key, value);
    }

    public Object getContextValue(String key) {
        return this.contextMap.get(key);
    }
}

