/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.equate;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;

public class ClearEquateCmd
implements Command<Program> {
    private String equateName;
    private Address addr;
    private int opIndex;
    private String msg;

    public ClearEquateCmd(String equateName, Address addr, int opIndex) {
        this.addr = addr;
        this.opIndex = opIndex;
        this.equateName = equateName;
    }

    public String getName() {
        return "Remove Equate";
    }

    public boolean applyTo(Program program) {
        EquateTable equateTable = program.getEquateTable();
        Equate equate = equateTable.getEquate(this.equateName);
        this.clearEquate(equate, equateTable);
        return true;
    }

    private void clearEquate(Equate equate, EquateTable equateTable) {
        if (equate == null) {
            return;
        }
        if (equate.getReferenceCount() <= 1) {
            equateTable.removeEquate(equate.getName());
        } else {
            equate.removeReference(this.addr, this.opIndex);
        }
    }

    public String getStatusMsg() {
        return this.msg;
    }
}

