/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BinaryAnalysisCommand;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class AbstractBinaryFormatAnalyzer
extends AbstractAnalyzer {
    protected BinaryAnalysisCommand command;

    protected AbstractBinaryFormatAnalyzer(BinaryAnalysisCommand command) {
        super(command.getName(), command.getName(), AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            boolean bl = this.command.applyTo(program, monitor);
            return bl;
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            log.setStatus(e.toString());
        }
        finally {
            log.copyFrom(this.command.getMessages());
        }
        return false;
    }

    @Override
    public final boolean canAnalyze(Program program) {
        return this.command.canApply(program);
    }

    @Override
    public final boolean getDefaultEnablement(Program program) {
        return this.command.canApply(program);
    }
}

