/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import generic.util.AbstractPeekableIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.CodeUnit;
import ghidra.trace.model.TraceAddressSnapRange;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class OverlappingObjectIterator<L, R>
extends AbstractPeekableIterator<Pair<L, R>> {
    public static final AddressRangeRanger ADDRESS_RANGE = new AddressRangeRanger();
    public static final SnapRangeKeyRanger SNAP_RANGE_KEY = new SnapRangeKeyRanger();
    public static final CodeUnitRanger CODE_UNIT = new CodeUnitRanger();
    private final Iterator<? extends L> left;
    private final Ranger<? super L> leftRanger;
    private final Iterator<? extends R> right;
    private final Ranger<? super R> rightRanger;
    private L nextL;
    private R nextR;
    private MyPair pair = new MyPair();

    public OverlappingObjectIterator(Iterator<? extends L> left, Ranger<? super L> leftRanger, Iterator<? extends R> right, Ranger<? super R> rightRanger) {
        this.left = left;
        this.leftRanger = leftRanger;
        this.right = right;
        this.rightRanger = rightRanger;
    }

    protected Pair<L, R> seekNext() {
        if (this.nextL != null) {
            assert (this.nextR != null);
            int cmp = this.leftRanger.getMaxAddress(this.nextL).compareTo((Object)this.rightRanger.getMaxAddress(this.nextR));
            if (cmp <= 0) {
                this.nextL = null;
            }
            if (cmp >= 0) {
                this.nextR = null;
            }
        } else assert (this.nextR == null);
        if (this.nextL == null) {
            if (!this.left.hasNext()) {
                return null;
            }
            this.nextL = this.left.next();
        }
        if (this.nextR == null) {
            if (!this.right.hasNext()) {
                return null;
            }
            this.nextR = this.right.next();
        }
        while (true) {
            if (this.leftRanger.getMaxAddress(this.nextL).compareTo((Object)this.rightRanger.getMinAddress(this.nextR)) < 0) {
                if (!this.left.hasNext()) {
                    this.nextL = null;
                    return null;
                }
                this.nextL = this.left.next();
                continue;
            }
            if (this.rightRanger.getMaxAddress(this.nextR).compareTo((Object)this.leftRanger.getMinAddress(this.nextL)) >= 0) break;
            if (!this.right.hasNext()) {
                this.nextR = null;
                return null;
            }
            this.nextR = this.right.next();
        }
        return this.pair;
    }

    private class MyPair
    extends Pair<L, R> {
        private MyPair() {
        }

        public R setValue(R value) {
            throw new UnsupportedOperationException();
        }

        public L getLeft() {
            return OverlappingObjectIterator.this.nextL;
        }

        public R getRight() {
            return OverlappingObjectIterator.this.nextR;
        }
    }

    public static interface Ranger<T> {
        public Address getMinAddress(T var1);

        public Address getMaxAddress(T var1);
    }

    public static class AddressRangeRanger
    implements Ranger<AddressRange> {
        @Override
        public Address getMinAddress(AddressRange t) {
            return t.getMinAddress();
        }

        @Override
        public Address getMaxAddress(AddressRange t) {
            return t.getMaxAddress();
        }
    }

    public static class SnapRangeKeyRanger
    implements Ranger<Map.Entry<TraceAddressSnapRange, ?>> {
        @Override
        public Address getMinAddress(Map.Entry<TraceAddressSnapRange, ?> t) {
            return t.getKey().getX1();
        }

        @Override
        public Address getMaxAddress(Map.Entry<TraceAddressSnapRange, ?> t) {
            return t.getKey().getX2();
        }
    }

    public static class CodeUnitRanger
    implements Ranger<CodeUnit> {
        @Override
        public Address getMinAddress(CodeUnit t) {
            return t.getMinAddress();
        }

        @Override
        public Address getMaxAddress(CodeUnit t) {
            return t.getMaxAddress();
        }
    }
}

