/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.util.GraphicsUtils;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class SimpleTextField
implements Field {
    protected String text;
    protected FontMetrics metrics;
    protected int startX;
    protected Color foregroundColor;
    protected int width;
    protected int preferredWidth;
    protected int heightAbove;
    protected int heightBelow;
    protected int numCols;
    protected boolean allowCursorAtEnd;
    protected boolean isPrimary;
    protected final FieldHighlightFactory hlFactory;

    public SimpleTextField(String text, FontMetrics fontMetrics, int startX, int width, boolean allowCursorAtEnd, FieldHighlightFactory hlFactory) {
        this.text = text;
        this.hlFactory = hlFactory;
        this.numCols = text.length();
        if (allowCursorAtEnd) {
            ++this.numCols;
        }
        this.setFontMetrics(fontMetrics);
        this.startX = startX;
        this.width = width;
        this.preferredWidth = fontMetrics.stringWidth(text);
        this.allowCursorAtEnd = allowCursorAtEnd;
    }

    public boolean isAllowCursorAtEnd() {
        return this.allowCursorAtEnd;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getHeight() {
        return this.heightAbove + this.heightBelow;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getNumDataRows() {
        return 1;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public int getNumCols(int row) {
        return this.numCols;
    }

    @Override
    public int getRow(int y) {
        return 0;
    }

    @Override
    public int getCol(int row, int x) {
        if (x < this.startX) {
            x = this.startX;
        } else if (x >= this.startX + this.width) {
            x = this.startX + this.width - 1;
        }
        int col = this.findColumn(this.text, x - this.startX);
        if (col >= this.numCols) {
            col = this.numCols - 1;
        }
        return col;
    }

    @Override
    public int getY(int row) {
        return -this.heightAbove;
    }

    @Override
    public int getX(int row, int col) {
        int x = 0;
        x = col < this.text.length() ? this.metrics.stringWidth(this.text.substring(0, col)) : this.metrics.stringWidth(this.text);
        return this.startX + x;
    }

    @Override
    public boolean isValid(int row, int col) {
        if (row != 0) {
            return false;
        }
        return col >= 0 && col <= this.numCols - 1;
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager colorManager, RowColLocation cursorLoc, int rowHeight) {
        this.paintSelection(g, colorManager, 0);
        this.paintHighlights(g, this.hlFactory.createHighlights(this, this.text, -1));
        g.setFont(this.metrics.getFont());
        if (this.foregroundColor == null) {
            this.foregroundColor = context.getForeground();
        }
        g.setColor(this.foregroundColor);
        GraphicsUtils.drawString(c, g, this.text, this.startX, 0);
        this.paintCursor(g, context.getCursorColor(), cursorLoc);
    }

    protected void paintSelection(Graphics g, FieldBackgroundColorManager colorManager, int row) {
        List<Highlight> selections = colorManager.getSelectionHighlights(row);
        for (Highlight highlight : selections) {
            g.setColor(highlight.getColor());
            int startCol = highlight.getStart();
            int endCol = highlight.getEnd();
            int x1 = this.findX(startCol);
            int x2 = endCol >= this.text.length() ? this.width : this.findX(endCol);
            g.fillRect(this.startX + x1, -this.getHeightAbove(), x2 - x1, this.getHeight());
        }
    }

    protected void paintHighlights(Graphics g, Highlight[] highlights) {
        for (Highlight highlight : highlights) {
            int startCol = Math.max(highlight.getStart(), 0);
            int endCol = Math.min(highlight.getEnd(), this.text.length());
            Color c = highlight.getColor();
            if (endCol < startCol) continue;
            int start = this.findX(startCol);
            int end = this.findX(endCol + 1);
            g.setColor(c);
            g.fillRect(this.startX + start, -this.getHeightAbove(), end - start, this.getHeight());
        }
    }

    private int findX(int column) {
        return this.metrics.stringWidth(this.text.substring(0, column));
    }

    private void paintCursor(Graphics g, Color cursorColor, RowColLocation cursorLoc) {
        if (cursorLoc == null) {
            return;
        }
        if (cursorLoc.col() < this.numCols) {
            g.setColor(cursorColor);
            int x = this.startX + this.metrics.stringWidth(this.text.substring(0, cursorLoc.col()));
            g.fillRect(x, -this.heightAbove, 2, this.heightAbove + this.heightBelow);
        }
    }

    @Override
    public Rectangle getCursorBounds(int row, int col) {
        if (row != 0) {
            return null;
        }
        int x = this.startX + this.metrics.stringWidth(this.text.substring(0, col));
        return new Rectangle(x, -this.heightAbove, 2, this.heightAbove + this.heightBelow);
    }

    protected int findColumn(String textString, int x) {
        int col;
        int startPos = 0;
        for (col = 0; col < textString.length() && x >= (startPos += this.metrics.charWidth(textString.charAt(col))); ++col) {
        }
        return col;
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.width && y >= -this.heightAbove && y < this.heightBelow;
    }

    public void setForeground(Color color) {
        this.foregroundColor = color;
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.heightAbove || topOfScreen > this.heightBelow) {
            return max;
        }
        if (direction > 0) {
            return this.heightBelow - topOfScreen;
        }
        return -this.heightAbove - topOfScreen;
    }

    public void setFontMetrics(FontMetrics metrics) {
        this.metrics = metrics;
        this.heightAbove = metrics.getMaxAscent() + metrics.getLeading();
        this.heightBelow = metrics.getMaxDescent();
    }

    public FontMetrics getFontMetrics() {
        return this.metrics;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean state) {
        this.isPrimary = state;
    }

    @Override
    public int getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        return this.heightBelow;
    }

    @Override
    public void rowHeightChanged(int newHeightAbove, int newHeightBelow) {
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getTextWithLineSeparators() {
        return this.text;
    }

    @Override
    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new RowColLocation(0, textOffset);
    }

    @Override
    public int screenLocationToTextOffset(int row, int col) {
        return col;
    }
}

