/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DetachedWindowNode;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.actions.AutoGeneratedDockingAction;
import generic.theme.GIcon;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

class ShowWindowAction
extends DockingAction
implements AutoGeneratedDockingAction,
Comparable<ShowWindowAction> {
    private static final Icon ICON = new GIcon("icon.window");
    private static final String MENU_WINDOW = "&Window";
    private static final int MAX_LENGTH = 40;
    private final DetachedWindowNode node;

    private static String truncateTitleAsNeeded(String title) {
        if (title.length() <= 40) {
            return title;
        }
        return title.substring(0, 37) + "...";
    }

    ShowWindowAction(DetachedWindowNode node) {
        super(ShowWindowAction.truncateTitleAsNeeded(node.getTitle()), "DockingWindows", false);
        this.node = node;
        this.setMenuBarData(new MenuData(new String[]{MENU_WINDOW, this.getName()}, ICON, "WindowGroup"));
        this.setHelpLocation(new HelpLocation("Tool", "DefaultTools"));
    }

    @Override
    public void actionPerformed(ActionContext context) {
        DockingWindowManager manager = DockingWindowManager.getActiveInstance();
        manager.toFront(this.node.getWindow());
    }

    @Override
    public int compareTo(ShowWindowAction o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }
}

